/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the duration and renewal status of the commitment period for a radio unit.
 * </p>
 * <p>
 * For pricing, see <a href="http://aws.amazon.com/private5g/pricing">Amazon Web Services Private 5G Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitmentConfiguration.Builder, CommitmentConfiguration> {
    private static final SdkField<Boolean> AUTOMATIC_RENEWAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("automaticRenewal").getter(getter(CommitmentConfiguration::automaticRenewal))
            .setter(setter(Builder::automaticRenewal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticRenewal").build()).build();

    private static final SdkField<String> COMMITMENT_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitmentLength").getter(getter(CommitmentConfiguration::commitmentLengthAsString))
            .setter(setter(Builder::commitmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_RENEWAL_FIELD,
            COMMITMENT_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean automaticRenewal;

    private final String commitmentLength;

    private CommitmentConfiguration(BuilderImpl builder) {
        this.automaticRenewal = builder.automaticRenewal;
        this.commitmentLength = builder.commitmentLength;
    }

    /**
     * <p>
     * Determines whether the commitment period for a radio unit is set to automatically renew for an additional 1 year
     * after your current commitment period expires.
     * </p>
     * <p>
     * Set to <code>True</code>, if you want your commitment period to automatically renew. Set to <code>False</code> if
     * you do not want your commitment to automatically renew.
     * </p>
     * <p>
     * You can do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set a 1-year commitment to automatically renew for an additional 1 year. The hourly rate for the additional year
     * will continue to be the same as your existing 1-year rate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set a 3-year commitment to automatically renew for an additional 1 year. The hourly rate for the additional year
     * will continue to be the same as your existing 3-year rate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Turn off a previously-enabled automatic renewal on a 1-year or 3-year commitment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You cannot use the automatic-renewal option for a 60-day commitment.
     * </p>
     * 
     * @return Determines whether the commitment period for a radio unit is set to automatically renew for an additional
     *         1 year after your current commitment period expires.</p>
     *         <p>
     *         Set to <code>True</code>, if you want your commitment period to automatically renew. Set to
     *         <code>False</code> if you do not want your commitment to automatically renew.
     *         </p>
     *         <p>
     *         You can do the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set a 1-year commitment to automatically renew for an additional 1 year. The hourly rate for the
     *         additional year will continue to be the same as your existing 1-year rate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set a 3-year commitment to automatically renew for an additional 1 year. The hourly rate for the
     *         additional year will continue to be the same as your existing 3-year rate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Turn off a previously-enabled automatic renewal on a 1-year or 3-year commitment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You cannot use the automatic-renewal option for a 60-day commitment.
     */
    public final Boolean automaticRenewal() {
        return automaticRenewal;
    }

    /**
     * <p>
     * The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitmentLength}
     * will return {@link CommitmentLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #commitmentLengthAsString}.
     * </p>
     * 
     * @return The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year
     *         period.
     * @see CommitmentLength
     */
    public final CommitmentLength commitmentLength() {
        return CommitmentLength.fromValue(commitmentLength);
    }

    /**
     * <p>
     * The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commitmentLength}
     * will return {@link CommitmentLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #commitmentLengthAsString}.
     * </p>
     * 
     * @return The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year
     *         period.
     * @see CommitmentLength
     */
    public final String commitmentLengthAsString() {
        return commitmentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticRenewal());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentLengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitmentConfiguration)) {
            return false;
        }
        CommitmentConfiguration other = (CommitmentConfiguration) obj;
        return Objects.equals(automaticRenewal(), other.automaticRenewal())
                && Objects.equals(commitmentLengthAsString(), other.commitmentLengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitmentConfiguration").add("AutomaticRenewal", automaticRenewal())
                .add("CommitmentLength", commitmentLengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "automaticRenewal":
            return Optional.ofNullable(clazz.cast(automaticRenewal()));
        case "commitmentLength":
            return Optional.ofNullable(clazz.cast(commitmentLengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("automaticRenewal", AUTOMATIC_RENEWAL_FIELD);
        map.put("commitmentLength", COMMITMENT_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommitmentConfiguration, T> g) {
        return obj -> g.apply((CommitmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitmentConfiguration> {
        /**
         * <p>
         * Determines whether the commitment period for a radio unit is set to automatically renew for an additional 1
         * year after your current commitment period expires.
         * </p>
         * <p>
         * Set to <code>True</code>, if you want your commitment period to automatically renew. Set to
         * <code>False</code> if you do not want your commitment to automatically renew.
         * </p>
         * <p>
         * You can do the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set a 1-year commitment to automatically renew for an additional 1 year. The hourly rate for the additional
         * year will continue to be the same as your existing 1-year rate.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set a 3-year commitment to automatically renew for an additional 1 year. The hourly rate for the additional
         * year will continue to be the same as your existing 3-year rate.
         * </p>
         * </li>
         * <li>
         * <p>
         * Turn off a previously-enabled automatic renewal on a 1-year or 3-year commitment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You cannot use the automatic-renewal option for a 60-day commitment.
         * </p>
         * 
         * @param automaticRenewal
         *        Determines whether the commitment period for a radio unit is set to automatically renew for an
         *        additional 1 year after your current commitment period expires.</p>
         *        <p>
         *        Set to <code>True</code>, if you want your commitment period to automatically renew. Set to
         *        <code>False</code> if you do not want your commitment to automatically renew.
         *        </p>
         *        <p>
         *        You can do the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set a 1-year commitment to automatically renew for an additional 1 year. The hourly rate for the
         *        additional year will continue to be the same as your existing 1-year rate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set a 3-year commitment to automatically renew for an additional 1 year. The hourly rate for the
         *        additional year will continue to be the same as your existing 3-year rate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Turn off a previously-enabled automatic renewal on a 1-year or 3-year commitment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You cannot use the automatic-renewal option for a 60-day commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticRenewal(Boolean automaticRenewal);

        /**
         * <p>
         * The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year period.
         * </p>
         * 
         * @param commitmentLength
         *        The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year
         *        period.
         * @see CommitmentLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentLength
         */
        Builder commitmentLength(String commitmentLength);

        /**
         * <p>
         * The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year period.
         * </p>
         * 
         * @param commitmentLength
         *        The duration of the commitment period for the radio unit. You can choose a 60-day, 1-year, or 3-year
         *        period.
         * @see CommitmentLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommitmentLength
         */
        Builder commitmentLength(CommitmentLength commitmentLength);
    }

    static final class BuilderImpl implements Builder {
        private Boolean automaticRenewal;

        private String commitmentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitmentConfiguration model) {
            automaticRenewal(model.automaticRenewal);
            commitmentLength(model.commitmentLength);
        }

        public final Boolean getAutomaticRenewal() {
            return automaticRenewal;
        }

        public final void setAutomaticRenewal(Boolean automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
        }

        @Override
        public final Builder automaticRenewal(Boolean automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
            return this;
        }

        public final String getCommitmentLength() {
            return commitmentLength;
        }

        public final void setCommitmentLength(String commitmentLength) {
            this.commitmentLength = commitmentLength;
        }

        @Override
        public final Builder commitmentLength(String commitmentLength) {
            this.commitmentLength = commitmentLength;
            return this;
        }

        @Override
        public final Builder commitmentLength(CommitmentLength commitmentLength) {
            this.commitmentLength(commitmentLength == null ? null : commitmentLength.toString());
            return this;
        }

        @Override
        public CommitmentConfiguration build() {
            return new CommitmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
