/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcknowledgeOrderReceiptRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<AcknowledgeOrderReceiptRequest.Builder, AcknowledgeOrderReceiptRequest> {
    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderArn").getter(getter(AcknowledgeOrderReceiptRequest::orderArn)).setter(setter(Builder::orderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String orderArn;

    private AcknowledgeOrderReceiptRequest(BuilderImpl builder) {
        super(builder);
        this.orderArn = builder.orderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the order.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the order.
     */
    public final String orderArn() {
        return orderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(orderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeOrderReceiptRequest)) {
            return false;
        }
        AcknowledgeOrderReceiptRequest other = (AcknowledgeOrderReceiptRequest) obj;
        return Objects.equals(orderArn(), other.orderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcknowledgeOrderReceiptRequest").add("OrderArn", orderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "orderArn":
            return Optional.ofNullable(clazz.cast(orderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("orderArn", ORDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeOrderReceiptRequest, T> g) {
        return obj -> g.apply((AcknowledgeOrderReceiptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcknowledgeOrderReceiptRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the order.
         * </p>
         * 
         * @param orderArn
         *        The Amazon Resource Name (ARN) of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderArn(String orderArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String orderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeOrderReceiptRequest model) {
            super(model);
            orderArn(model.orderArn);
        }

        public final String getOrderArn() {
            return orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcknowledgeOrderReceiptRequest build() {
            return new AcknowledgeOrderReceiptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
