/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.NetworkSiteStatus;
import software.amazon.awssdk.services.privatenetworks.model.SitePlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkSite
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkSite> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(NetworkSite.getter(NetworkSite::availabilityZone)).setter(NetworkSite.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(NetworkSite.getter(NetworkSite::availabilityZoneId)).setter(NetworkSite.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(NetworkSite.getter(NetworkSite::createdAt)).setter(NetworkSite.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<SitePlan> CURRENT_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentPlan").getter(NetworkSite.getter(NetworkSite::currentPlan)).setter(NetworkSite.setter(Builder::currentPlan)).constructor(SitePlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPlan").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(NetworkSite.getter(NetworkSite::description)).setter(NetworkSite.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(NetworkSite.getter(NetworkSite::networkArn)).setter(NetworkSite.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(NetworkSite.getter(NetworkSite::networkSiteArn)).setter(NetworkSite.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()}).build();
    private static final SdkField<String> NETWORK_SITE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteName").getter(NetworkSite.getter(NetworkSite::networkSiteName)).setter(NetworkSite.setter(Builder::networkSiteName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteName").build()}).build();
    private static final SdkField<SitePlan> PENDING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pendingPlan").getter(NetworkSite.getter(NetworkSite::pendingPlan)).setter(NetworkSite.setter(Builder::pendingPlan)).constructor(SitePlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPlan").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(NetworkSite.getter(NetworkSite::statusAsString)).setter(NetworkSite.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(NetworkSite.getter(NetworkSite::statusReason)).setter(NetworkSite.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CREATED_AT_FIELD, CURRENT_PLAN_FIELD, DESCRIPTION_FIELD, NETWORK_ARN_FIELD, NETWORK_SITE_ARN_FIELD, NETWORK_SITE_NAME_FIELD, PENDING_PLAN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("currentPlan", CURRENT_PLAN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("networkArn", NETWORK_ARN_FIELD);
            this.put("networkSiteArn", NETWORK_SITE_ARN_FIELD);
            this.put("networkSiteName", NETWORK_SITE_NAME_FIELD);
            this.put("pendingPlan", PENDING_PLAN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Instant createdAt;
    private final SitePlan currentPlan;
    private final String description;
    private final String networkArn;
    private final String networkSiteArn;
    private final String networkSiteName;
    private final SitePlan pendingPlan;
    private final String status;
    private final String statusReason;

    private NetworkSite(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.createdAt = builder.createdAt;
        this.currentPlan = builder.currentPlan;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.networkSiteName = builder.networkSiteName;
        this.pendingPlan = builder.pendingPlan;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final SitePlan currentPlan() {
        return this.currentPlan;
    }

    public final String description() {
        return this.description;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    public final String networkSiteName() {
        return this.networkSiteName;
    }

    public final SitePlan pendingPlan() {
        return this.pendingPlan;
    }

    public final NetworkSiteStatus status() {
        return NetworkSiteStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSite)) {
            return false;
        }
        NetworkSite other = (NetworkSite)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.currentPlan(), other.currentPlan()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn()) && Objects.equals(this.networkSiteName(), other.networkSiteName()) && Objects.equals(this.pendingPlan(), other.pendingPlan()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkSite").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CreatedAt", (Object)this.createdAt()).add("CurrentPlan", (Object)this.currentPlan()).add("Description", (Object)this.description()).add("NetworkArn", (Object)this.networkArn()).add("NetworkSiteArn", (Object)this.networkSiteArn()).add("NetworkSiteName", (Object)this.networkSiteName()).add("PendingPlan", (Object)this.pendingPlan()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "currentPlan": {
                return Optional.ofNullable(clazz.cast(this.currentPlan()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
            case "networkSiteName": {
                return Optional.ofNullable(clazz.cast(this.networkSiteName()));
            }
            case "pendingPlan": {
                return Optional.ofNullable(clazz.cast(this.pendingPlan()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkSite, T> g) {
        return obj -> g.apply((NetworkSite)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private Instant createdAt;
        private SitePlan currentPlan;
        private String description;
        private String networkArn;
        private String networkSiteArn;
        private String networkSiteName;
        private SitePlan pendingPlan;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSite model) {
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.createdAt(model.createdAt);
            this.currentPlan(model.currentPlan);
            this.description(model.description);
            this.networkArn(model.networkArn);
            this.networkSiteArn(model.networkSiteArn);
            this.networkSiteName(model.networkSiteName);
            this.pendingPlan(model.pendingPlan);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final SitePlan.Builder getCurrentPlan() {
            return this.currentPlan != null ? this.currentPlan.toBuilder() : null;
        }

        public final void setCurrentPlan(SitePlan.BuilderImpl currentPlan) {
            this.currentPlan = currentPlan != null ? currentPlan.build() : null;
        }

        @Override
        public final Builder currentPlan(SitePlan currentPlan) {
            this.currentPlan = currentPlan;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getNetworkSiteName() {
            return this.networkSiteName;
        }

        public final void setNetworkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
        }

        @Override
        public final Builder networkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
            return this;
        }

        public final SitePlan.Builder getPendingPlan() {
            return this.pendingPlan != null ? this.pendingPlan.toBuilder() : null;
        }

        public final void setPendingPlan(SitePlan.BuilderImpl pendingPlan) {
            this.pendingPlan = pendingPlan != null ? pendingPlan.build() : null;
        }

        @Override
        public final Builder pendingPlan(SitePlan pendingPlan) {
            this.pendingPlan = pendingPlan;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkSiteStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public NetworkSite build() {
            return new NetworkSite(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkSite> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder createdAt(Instant var1);

        public Builder currentPlan(SitePlan var1);

        default public Builder currentPlan(Consumer<SitePlan.Builder> currentPlan) {
            return this.currentPlan((SitePlan)((SitePlan.Builder)SitePlan.builder().applyMutation(currentPlan)).build());
        }

        public Builder description(String var1);

        public Builder networkArn(String var1);

        public Builder networkSiteArn(String var1);

        public Builder networkSiteName(String var1);

        public Builder pendingPlan(SitePlan var1);

        default public Builder pendingPlan(Consumer<SitePlan.Builder> pendingPlan) {
            return this.pendingPlan((SitePlan)((SitePlan.Builder)SitePlan.builder().applyMutation(pendingPlan)).build());
        }

        public Builder status(String var1);

        public Builder status(NetworkSiteStatus var1);

        public Builder statusReason(String var1);
    }
}

