/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResource;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceListCopier;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworkResourcesResponse
extends PrivateNetworksResponse
implements ToCopyableBuilder<Builder, ListNetworkResourcesResponse> {
    private static final SdkField<List<NetworkResource>> NETWORK_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkResources").getter(ListNetworkResourcesResponse.getter(ListNetworkResourcesResponse::networkResources)).setter(ListNetworkResourcesResponse.setter(Builder::networkResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNetworkResourcesResponse.getter(ListNetworkResourcesResponse::nextToken)).setter(ListNetworkResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("networkResources", NETWORK_RESOURCES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<NetworkResource> networkResources;
    private final String nextToken;

    private ListNetworkResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.networkResources = builder.networkResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkResources() {
        return this.networkResources != null && !(this.networkResources instanceof SdkAutoConstructList);
    }

    public final List<NetworkResource> networkResources() {
        return this.networkResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkResources() ? this.networkResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkResourcesResponse)) {
            return false;
        }
        ListNetworkResourcesResponse other = (ListNetworkResourcesResponse)((Object)obj);
        return this.hasNetworkResources() == other.hasNetworkResources() && Objects.equals(this.networkResources(), other.networkResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNetworkResourcesResponse").add("NetworkResources", this.hasNetworkResources() ? this.networkResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkResources": {
                return Optional.ofNullable(clazz.cast(this.networkResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkResourcesResponse, T> g) {
        return obj -> g.apply((ListNetworkResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksResponse.BuilderImpl
    implements Builder {
        private List<NetworkResource> networkResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkResourcesResponse model) {
            super(model);
            this.networkResources(model.networkResources);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkResource.Builder> getNetworkResources() {
            List<NetworkResource.Builder> result = NetworkResourceListCopier.copyToBuilder(this.networkResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkResources(Collection<NetworkResource.BuilderImpl> networkResources) {
            this.networkResources = NetworkResourceListCopier.copyFromBuilder(networkResources);
        }

        @Override
        public final Builder networkResources(Collection<NetworkResource> networkResources) {
            this.networkResources = NetworkResourceListCopier.copy(networkResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkResources(NetworkResource ... networkResources) {
            this.networkResources(Arrays.asList(networkResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkResources(Consumer<NetworkResource.Builder> ... networkResources) {
            this.networkResources(Stream.of(networkResources).map(c -> (NetworkResource)((NetworkResource.Builder)NetworkResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworkResourcesResponse build() {
            return new ListNetworkResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PrivateNetworksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworkResourcesResponse> {
        public Builder networkResources(Collection<NetworkResource> var1);

        public Builder networkResources(NetworkResource ... var1);

        public Builder networkResources(Consumer<NetworkResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

