/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about tracking a shipment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackingInformation.Builder, TrackingInformation> {
    private static final SdkField<String> TRACKING_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingNumber").getter(getter(TrackingInformation::trackingNumber))
            .setter(setter(Builder::trackingNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("trackingNumber", TRACKING_NUMBER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String trackingNumber;

    private TrackingInformation(BuilderImpl builder) {
        this.trackingNumber = builder.trackingNumber;
    }

    /**
     * <p>
     * The tracking number of the shipment.
     * </p>
     * 
     * @return The tracking number of the shipment.
     */
    public final String trackingNumber() {
        return trackingNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackingNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingInformation)) {
            return false;
        }
        TrackingInformation other = (TrackingInformation) obj;
        return Objects.equals(trackingNumber(), other.trackingNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackingInformation").add("TrackingNumber", trackingNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackingNumber":
            return Optional.ofNullable(clazz.cast(trackingNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrackingInformation, T> g) {
        return obj -> g.apply((TrackingInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackingInformation> {
        /**
         * <p>
         * The tracking number of the shipment.
         * </p>
         * 
         * @param trackingNumber
         *        The tracking number of the shipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingNumber(String trackingNumber);
    }

    static final class BuilderImpl implements Builder {
        private String trackingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingInformation model) {
            trackingNumber(model.trackingNumber);
        }

        public final String getTrackingNumber() {
            return trackingNumber;
        }

        public final void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        @Override
        public final Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        @Override
        public TrackingInformation build() {
            return new TrackingInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
