/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeactivateDeviceIdentifierResponse extends PrivateNetworksResponse implements
        ToCopyableBuilder<DeactivateDeviceIdentifierResponse.Builder, DeactivateDeviceIdentifierResponse> {
    private static final SdkField<DeviceIdentifier> DEVICE_IDENTIFIER_FIELD = SdkField
            .<DeviceIdentifier> builder(MarshallingType.SDK_POJO).memberName("deviceIdentifier")
            .getter(getter(DeactivateDeviceIdentifierResponse::deviceIdentifier)).setter(setter(Builder::deviceIdentifier))
            .constructor(DeviceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deviceIdentifier", DEVICE_IDENTIFIER_FIELD);
                }
            });

    private final DeviceIdentifier deviceIdentifier;

    private DeactivateDeviceIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.deviceIdentifier = builder.deviceIdentifier;
    }

    /**
     * <p>
     * Information about the device identifier.
     * </p>
     * 
     * @return Information about the device identifier.
     */
    public final DeviceIdentifier deviceIdentifier() {
        return deviceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivateDeviceIdentifierResponse)) {
            return false;
        }
        DeactivateDeviceIdentifierResponse other = (DeactivateDeviceIdentifierResponse) obj;
        return Objects.equals(deviceIdentifier(), other.deviceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeactivateDeviceIdentifierResponse").add("DeviceIdentifier", deviceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceIdentifier":
            return Optional.ofNullable(clazz.cast(deviceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeactivateDeviceIdentifierResponse, T> g) {
        return obj -> g.apply((DeactivateDeviceIdentifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeactivateDeviceIdentifierResponse> {
        /**
         * <p>
         * Information about the device identifier.
         * </p>
         * 
         * @param deviceIdentifier
         *        Information about the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIdentifier(DeviceIdentifier deviceIdentifier);

        /**
         * <p>
         * Information about the device identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceIdentifier.Builder} avoiding the
         * need to create one manually via {@link DeviceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceIdentifier(DeviceIdentifier)}.
         * 
         * @param deviceIdentifier
         *        a consumer that will call methods on {@link DeviceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceIdentifier(DeviceIdentifier)
         */
        default Builder deviceIdentifier(Consumer<DeviceIdentifier.Builder> deviceIdentifier) {
            return deviceIdentifier(DeviceIdentifier.builder().applyMutation(deviceIdentifier).build());
        }
    }

    static final class BuilderImpl extends PrivateNetworksResponse.BuilderImpl implements Builder {
        private DeviceIdentifier deviceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivateDeviceIdentifierResponse model) {
            super(model);
            deviceIdentifier(model.deviceIdentifier);
        }

        public final DeviceIdentifier.Builder getDeviceIdentifier() {
            return deviceIdentifier != null ? deviceIdentifier.toBuilder() : null;
        }

        public final void setDeviceIdentifier(DeviceIdentifier.BuilderImpl deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier != null ? deviceIdentifier.build() : null;
        }

        @Override
        public final Builder deviceIdentifier(DeviceIdentifier deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
            return this;
        }

        @Override
        public DeactivateDeviceIdentifierResponse build() {
            return new DeactivateDeviceIdentifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
