/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("city")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("company")
            .getter(getter(Address::company)).setter(setter(Builder::company))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("company").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("country")
            .getter(getter(Address::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(Address::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Address::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumber").getter(getter(Address::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()).build();

    private static final SdkField<String> STATE_OR_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateOrProvince").getter(getter(Address::stateOrProvince)).setter(setter(Builder::stateOrProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrProvince").build()).build();

    private static final SdkField<String> STREET1_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("street1")
            .getter(getter(Address::street1)).setter(setter(Builder::street1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street1").build()).build();

    private static final SdkField<String> STREET2_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("street2")
            .getter(getter(Address::street2)).setter(setter(Builder::street2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street2").build()).build();

    private static final SdkField<String> STREET3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("street3")
            .getter(getter(Address::street3)).setter(setter(Builder::street3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("street3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COMPANY_FIELD,
            COUNTRY_FIELD, EMAIL_ADDRESS_FIELD, NAME_FIELD, PHONE_NUMBER_FIELD, POSTAL_CODE_FIELD, STATE_OR_PROVINCE_FIELD,
            STREET1_FIELD, STREET2_FIELD, STREET3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("city", CITY_FIELD);
                    put("company", COMPANY_FIELD);
                    put("country", COUNTRY_FIELD);
                    put("emailAddress", EMAIL_ADDRESS_FIELD);
                    put("name", NAME_FIELD);
                    put("phoneNumber", PHONE_NUMBER_FIELD);
                    put("postalCode", POSTAL_CODE_FIELD);
                    put("stateOrProvince", STATE_OR_PROVINCE_FIELD);
                    put("street1", STREET1_FIELD);
                    put("street2", STREET2_FIELD);
                    put("street3", STREET3_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String city;

    private final String company;

    private final String country;

    private final String emailAddress;

    private final String name;

    private final String phoneNumber;

    private final String postalCode;

    private final String stateOrProvince;

    private final String street1;

    private final String street2;

    private final String street3;

    private Address(BuilderImpl builder) {
        this.city = builder.city;
        this.company = builder.company;
        this.country = builder.country;
        this.emailAddress = builder.emailAddress;
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.postalCode = builder.postalCode;
        this.stateOrProvince = builder.stateOrProvince;
        this.street1 = builder.street1;
        this.street2 = builder.street2;
        this.street3 = builder.street3;
    }

    /**
     * <p>
     * The city for this address.
     * </p>
     * 
     * @return The city for this address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The company name for this address.
     * </p>
     * 
     * @return The company name for this address.
     */
    public final String company() {
        return company;
    }

    /**
     * <p>
     * The country for this address.
     * </p>
     * 
     * @return The country for this address.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The recipient's email address.
     * </p>
     * 
     * @return The recipient's email address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The recipient's name for this address.
     * </p>
     * 
     * @return The recipient's name for this address.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The recipient's phone number.
     * </p>
     * 
     * @return The recipient's phone number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The postal code for this address.
     * </p>
     * 
     * @return The postal code for this address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The state or province for this address.
     * </p>
     * 
     * @return The state or province for this address.
     */
    public final String stateOrProvince() {
        return stateOrProvince;
    }

    /**
     * <p>
     * The first line of the street address.
     * </p>
     * 
     * @return The first line of the street address.
     */
    public final String street1() {
        return street1;
    }

    /**
     * <p>
     * The second line of the street address.
     * </p>
     * 
     * @return The second line of the street address.
     */
    public final String street2() {
        return street2;
    }

    /**
     * <p>
     * The third line of the street address.
     * </p>
     * 
     * @return The third line of the street address.
     */
    public final String street3() {
        return street3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(street1());
        hashCode = 31 * hashCode + Objects.hashCode(street2());
        hashCode = 31 * hashCode + Objects.hashCode(street3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(company(), other.company())
                && Objects.equals(country(), other.country()) && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(name(), other.name()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(stateOrProvince(), other.stateOrProvince())
                && Objects.equals(street1(), other.street1()) && Objects.equals(street2(), other.street2())
                && Objects.equals(street3(), other.street3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Company", company() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateOrProvince", stateOrProvince() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street1", street1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street2", street2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street3", street3() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "city":
            return Optional.ofNullable(clazz.cast(city()));
        case "company":
            return Optional.ofNullable(clazz.cast(company()));
        case "country":
            return Optional.ofNullable(clazz.cast(country()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "phoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "postalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "stateOrProvince":
            return Optional.ofNullable(clazz.cast(stateOrProvince()));
        case "street1":
            return Optional.ofNullable(clazz.cast(street1()));
        case "street2":
            return Optional.ofNullable(clazz.cast(street2()));
        case "street3":
            return Optional.ofNullable(clazz.cast(street3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The city for this address.
         * </p>
         * 
         * @param city
         *        The city for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The company name for this address.
         * </p>
         * 
         * @param company
         *        The company name for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * The country for this address.
         * </p>
         * 
         * @param country
         *        The country for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The recipient's email address.
         * </p>
         * 
         * @param emailAddress
         *        The recipient's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The recipient's name for this address.
         * </p>
         * 
         * @param name
         *        The recipient's name for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The recipient's phone number.
         * </p>
         * 
         * @param phoneNumber
         *        The recipient's phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The postal code for this address.
         * </p>
         * 
         * @param postalCode
         *        The postal code for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The state or province for this address.
         * </p>
         * 
         * @param stateOrProvince
         *        The state or province for this address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrProvince(String stateOrProvince);

        /**
         * <p>
         * The first line of the street address.
         * </p>
         * 
         * @param street1
         *        The first line of the street address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street1(String street1);

        /**
         * <p>
         * The second line of the street address.
         * </p>
         * 
         * @param street2
         *        The second line of the street address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street2(String street2);

        /**
         * <p>
         * The third line of the street address.
         * </p>
         * 
         * @param street3
         *        The third line of the street address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street3(String street3);
    }

    static final class BuilderImpl implements Builder {
        private String city;

        private String company;

        private String country;

        private String emailAddress;

        private String name;

        private String phoneNumber;

        private String postalCode;

        private String stateOrProvince;

        private String street1;

        private String street2;

        private String street3;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            city(model.city);
            company(model.company);
            country(model.country);
            emailAddress(model.emailAddress);
            name(model.name);
            phoneNumber(model.phoneNumber);
            postalCode(model.postalCode);
            stateOrProvince(model.stateOrProvince);
            street1(model.street1);
            street2(model.street2);
            street3(model.street3);
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrProvince() {
            return stateOrProvince;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final String getStreet1() {
            return street1;
        }

        public final void setStreet1(String street1) {
            this.street1 = street1;
        }

        @Override
        public final Builder street1(String street1) {
            this.street1 = street1;
            return this;
        }

        public final String getStreet2() {
            return street2;
        }

        public final void setStreet2(String street2) {
            this.street2 = street2;
        }

        @Override
        public final Builder street2(String street2) {
            this.street2 = street2;
            return this;
        }

        public final String getStreet3() {
            return street3;
        }

        public final void setStreet3(String street3) {
            this.street3 = street3;
        }

        @Override
        public final Builder street3(String street3) {
            this.street3 = street3;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
