/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an order.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Order implements SdkPojo, Serializable, ToCopyableBuilder<Order.Builder, Order> {
    private static final SdkField<String> ACKNOWLEDGMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acknowledgmentStatus").getter(getter(Order::acknowledgmentStatusAsString))
            .setter(setter(Builder::acknowledgmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgmentStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Order::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(Order::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteArn").getter(getter(Order::networkSiteArn)).setter(setter(Builder::networkSiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()).build();

    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderArn").getter(getter(Order::orderArn)).setter(setter(Builder::orderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()).build();

    private static final SdkField<List<OrderedResourceDefinition>> ORDERED_RESOURCES_FIELD = SdkField
            .<List<OrderedResourceDefinition>> builder(MarshallingType.LIST)
            .memberName("orderedResources")
            .getter(getter(Order::orderedResources))
            .setter(setter(Builder::orderedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderedResourceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderedResourceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("shippingAddress").getter(getter(Order::shippingAddress)).setter(setter(Builder::shippingAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()).build();

    private static final SdkField<List<TrackingInformation>> TRACKING_INFORMATION_FIELD = SdkField
            .<List<TrackingInformation>> builder(MarshallingType.LIST)
            .memberName("trackingInformation")
            .getter(getter(Order::trackingInformation))
            .setter(setter(Builder::trackingInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingInformation").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrackingInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrackingInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACKNOWLEDGMENT_STATUS_FIELD,
            CREATED_AT_FIELD, NETWORK_ARN_FIELD, NETWORK_SITE_ARN_FIELD, ORDER_ARN_FIELD, ORDERED_RESOURCES_FIELD,
            SHIPPING_ADDRESS_FIELD, TRACKING_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acknowledgmentStatus;

    private final Instant createdAt;

    private final String networkArn;

    private final String networkSiteArn;

    private final String orderArn;

    private final List<OrderedResourceDefinition> orderedResources;

    private final Address shippingAddress;

    private final List<TrackingInformation> trackingInformation;

    private Order(BuilderImpl builder) {
        this.acknowledgmentStatus = builder.acknowledgmentStatus;
        this.createdAt = builder.createdAt;
        this.networkArn = builder.networkArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.orderArn = builder.orderArn;
        this.orderedResources = builder.orderedResources;
        this.shippingAddress = builder.shippingAddress;
        this.trackingInformation = builder.trackingInformation;
    }

    /**
     * <p>
     * The acknowledgement status of the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acknowledgmentStatus} will return {@link AcknowledgmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #acknowledgmentStatusAsString}.
     * </p>
     * 
     * @return The acknowledgement status of the order.
     * @see AcknowledgmentStatus
     */
    public final AcknowledgmentStatus acknowledgmentStatus() {
        return AcknowledgmentStatus.fromValue(acknowledgmentStatus);
    }

    /**
     * <p>
     * The acknowledgement status of the order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acknowledgmentStatus} will return {@link AcknowledgmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #acknowledgmentStatusAsString}.
     * </p>
     * 
     * @return The acknowledgement status of the order.
     * @see AcknowledgmentStatus
     */
    public final String acknowledgmentStatusAsString() {
        return acknowledgmentStatus;
    }

    /**
     * <p>
     * The creation time of the order.
     * </p>
     * 
     * @return The creation time of the order.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network associated with this order.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network associated with this order.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network site associated with this order.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network site associated with this order.
     */
    public final String networkSiteArn() {
        return networkSiteArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the order.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the order.
     */
    public final String orderArn() {
        return orderArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrderedResources() {
        return orderedResources != null && !(orderedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the network resources placed in the order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderedResources} method.
     * </p>
     * 
     * @return A list of the network resources placed in the order.
     */
    public final List<OrderedResourceDefinition> orderedResources() {
        return orderedResources;
    }

    /**
     * <p>
     * The shipping address of the order.
     * </p>
     * 
     * @return The shipping address of the order.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrackingInformation property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrackingInformation() {
        return trackingInformation != null && !(trackingInformation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tracking information of the order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrackingInformation} method.
     * </p>
     * 
     * @return The tracking information of the order.
     */
    public final List<TrackingInformation> trackingInformation() {
        return trackingInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedResources() ? orderedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrackingInformation() ? trackingInformation() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order) obj;
        return Objects.equals(acknowledgmentStatusAsString(), other.acknowledgmentStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(networkArn(), other.networkArn())
                && Objects.equals(networkSiteArn(), other.networkSiteArn()) && Objects.equals(orderArn(), other.orderArn())
                && hasOrderedResources() == other.hasOrderedResources()
                && Objects.equals(orderedResources(), other.orderedResources())
                && Objects.equals(shippingAddress(), other.shippingAddress())
                && hasTrackingInformation() == other.hasTrackingInformation()
                && Objects.equals(trackingInformation(), other.trackingInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Order").add("AcknowledgmentStatus", acknowledgmentStatusAsString())
                .add("CreatedAt", createdAt()).add("NetworkArn", networkArn()).add("NetworkSiteArn", networkSiteArn())
                .add("OrderArn", orderArn()).add("OrderedResources", hasOrderedResources() ? orderedResources() : null)
                .add("ShippingAddress", shippingAddress())
                .add("TrackingInformation", hasTrackingInformation() ? trackingInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acknowledgmentStatus":
            return Optional.ofNullable(clazz.cast(acknowledgmentStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "networkSiteArn":
            return Optional.ofNullable(clazz.cast(networkSiteArn()));
        case "orderArn":
            return Optional.ofNullable(clazz.cast(orderArn()));
        case "orderedResources":
            return Optional.ofNullable(clazz.cast(orderedResources()));
        case "shippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "trackingInformation":
            return Optional.ofNullable(clazz.cast(trackingInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Order, T> g) {
        return obj -> g.apply((Order) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Order> {
        /**
         * <p>
         * The acknowledgement status of the order.
         * </p>
         * 
         * @param acknowledgmentStatus
         *        The acknowledgement status of the order.
         * @see AcknowledgmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcknowledgmentStatus
         */
        Builder acknowledgmentStatus(String acknowledgmentStatus);

        /**
         * <p>
         * The acknowledgement status of the order.
         * </p>
         * 
         * @param acknowledgmentStatus
         *        The acknowledgement status of the order.
         * @see AcknowledgmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcknowledgmentStatus
         */
        Builder acknowledgmentStatus(AcknowledgmentStatus acknowledgmentStatus);

        /**
         * <p>
         * The creation time of the order.
         * </p>
         * 
         * @param createdAt
         *        The creation time of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network associated with this order.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network associated with this order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network site associated with this order.
         * </p>
         * 
         * @param networkSiteArn
         *        The Amazon Resource Name (ARN) of the network site associated with this order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteArn(String networkSiteArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the order.
         * </p>
         * 
         * @param orderArn
         *        The Amazon Resource Name (ARN) of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderArn(String orderArn);

        /**
         * <p>
         * A list of the network resources placed in the order.
         * </p>
         * 
         * @param orderedResources
         *        A list of the network resources placed in the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedResources(Collection<OrderedResourceDefinition> orderedResources);

        /**
         * <p>
         * A list of the network resources placed in the order.
         * </p>
         * 
         * @param orderedResources
         *        A list of the network resources placed in the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedResources(OrderedResourceDefinition... orderedResources);

        /**
         * <p>
         * A list of the network resources placed in the order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link #orderedResources(List<OrderedResourceDefinition>)}.
         * 
         * @param orderedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.privatenetworks.model.OrderedResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedResources(java.util.Collection<OrderedResourceDefinition>)
         */
        Builder orderedResources(Consumer<OrderedResourceDefinition.Builder>... orderedResources);

        /**
         * <p>
         * The shipping address of the order.
         * </p>
         * 
         * @param shippingAddress
         *        The shipping address of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The shipping address of the order.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * The tracking information of the order.
         * </p>
         * 
         * @param trackingInformation
         *        The tracking information of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingInformation(Collection<TrackingInformation> trackingInformation);

        /**
         * <p>
         * The tracking information of the order.
         * </p>
         * 
         * @param trackingInformation
         *        The tracking information of the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingInformation(TrackingInformation... trackingInformation);

        /**
         * <p>
         * The tracking information of the order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.privatenetworks.model.TrackingInformation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.privatenetworks.model.TrackingInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.privatenetworks.model.TrackingInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #trackingInformation(List<TrackingInformation>)}.
         * 
         * @param trackingInformation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.privatenetworks.model.TrackingInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingInformation(java.util.Collection<TrackingInformation>)
         */
        Builder trackingInformation(Consumer<TrackingInformation.Builder>... trackingInformation);
    }

    static final class BuilderImpl implements Builder {
        private String acknowledgmentStatus;

        private Instant createdAt;

        private String networkArn;

        private String networkSiteArn;

        private String orderArn;

        private List<OrderedResourceDefinition> orderedResources = DefaultSdkAutoConstructList.getInstance();

        private Address shippingAddress;

        private List<TrackingInformation> trackingInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            acknowledgmentStatus(model.acknowledgmentStatus);
            createdAt(model.createdAt);
            networkArn(model.networkArn);
            networkSiteArn(model.networkSiteArn);
            orderArn(model.orderArn);
            orderedResources(model.orderedResources);
            shippingAddress(model.shippingAddress);
            trackingInformation(model.trackingInformation);
        }

        public final String getAcknowledgmentStatus() {
            return acknowledgmentStatus;
        }

        public final void setAcknowledgmentStatus(String acknowledgmentStatus) {
            this.acknowledgmentStatus = acknowledgmentStatus;
        }

        @Override
        public final Builder acknowledgmentStatus(String acknowledgmentStatus) {
            this.acknowledgmentStatus = acknowledgmentStatus;
            return this;
        }

        @Override
        public final Builder acknowledgmentStatus(AcknowledgmentStatus acknowledgmentStatus) {
            this.acknowledgmentStatus(acknowledgmentStatus == null ? null : acknowledgmentStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getOrderArn() {
            return orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final List<OrderedResourceDefinition.Builder> getOrderedResources() {
            List<OrderedResourceDefinition.Builder> result = OrderedResourceDefinitionsCopier
                    .copyToBuilder(this.orderedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedResources(Collection<OrderedResourceDefinition.BuilderImpl> orderedResources) {
            this.orderedResources = OrderedResourceDefinitionsCopier.copyFromBuilder(orderedResources);
        }

        @Override
        public final Builder orderedResources(Collection<OrderedResourceDefinition> orderedResources) {
            this.orderedResources = OrderedResourceDefinitionsCopier.copy(orderedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedResources(OrderedResourceDefinition... orderedResources) {
            orderedResources(Arrays.asList(orderedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedResources(Consumer<OrderedResourceDefinition.Builder>... orderedResources) {
            orderedResources(Stream.of(orderedResources).map(c -> OrderedResourceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final List<TrackingInformation.Builder> getTrackingInformation() {
            List<TrackingInformation.Builder> result = TrackingInformationListCopier.copyToBuilder(this.trackingInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrackingInformation(Collection<TrackingInformation.BuilderImpl> trackingInformation) {
            this.trackingInformation = TrackingInformationListCopier.copyFromBuilder(trackingInformation);
        }

        @Override
        public final Builder trackingInformation(Collection<TrackingInformation> trackingInformation) {
            this.trackingInformation = TrackingInformationListCopier.copy(trackingInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackingInformation(TrackingInformation... trackingInformation) {
            trackingInformation(Arrays.asList(trackingInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackingInformation(Consumer<TrackingInformation.Builder>... trackingInformation) {
            trackingInformation(Stream.of(trackingInformation).map(c -> TrackingInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Order build() {
            return new Order(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
