/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNetworkSiteRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, UpdateNetworkSiteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateNetworkSiteRequest.getter(UpdateNetworkSiteRequest::clientToken)).setter(UpdateNetworkSiteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateNetworkSiteRequest.getter(UpdateNetworkSiteRequest::description)).setter(UpdateNetworkSiteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(UpdateNetworkSiteRequest.getter(UpdateNetworkSiteRequest::networkSiteArn)).setter(UpdateNetworkSiteRequest.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NETWORK_SITE_ARN_FIELD));
    private final String clientToken;
    private final String description;
    private final String networkSiteArn;

    private UpdateNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.networkSiteArn = builder.networkSiteArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkSiteRequest)) {
            return false;
        }
        UpdateNetworkSiteRequest other = (UpdateNetworkSiteRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNetworkSiteRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("NetworkSiteArn", (Object)this.networkSiteArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkSiteRequest, T> g) {
        return obj -> g.apply((UpdateNetworkSiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String networkSiteArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkSiteRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.networkSiteArn(model.networkSiteArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkSiteRequest build() {
            return new UpdateNetworkSiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNetworkSiteRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder networkSiteArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

