/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.SitePlan;
import software.amazon.awssdk.services.privatenetworks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkSiteRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, CreateNetworkSiteRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::availabilityZone)).setter(CreateNetworkSiteRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::availabilityZoneId)).setter(CreateNetworkSiteRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::clientToken)).setter(CreateNetworkSiteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::description)).setter(CreateNetworkSiteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::networkArn)).setter(CreateNetworkSiteRequest.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> NETWORK_SITE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteName").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::networkSiteName)).setter(CreateNetworkSiteRequest.setter(Builder::networkSiteName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteName").build()}).build();
    private static final SdkField<SitePlan> PENDING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pendingPlan").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::pendingPlan)).setter(CreateNetworkSiteRequest.setter(Builder::pendingPlan)).constructor(SitePlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPlan").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateNetworkSiteRequest.getter(CreateNetworkSiteRequest::tags)).setter(CreateNetworkSiteRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NETWORK_ARN_FIELD, NETWORK_SITE_NAME_FIELD, PENDING_PLAN_FIELD, TAGS_FIELD));
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String clientToken;
    private final String description;
    private final String networkArn;
    private final String networkSiteName;
    private final SitePlan pendingPlan;
    private final Map<String, String> tags;

    private CreateNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.networkArn = builder.networkArn;
        this.networkSiteName = builder.networkSiteName;
        this.pendingPlan = builder.pendingPlan;
        this.tags = builder.tags;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String networkSiteName() {
        return this.networkSiteName;
    }

    public final SitePlan pendingPlan() {
        return this.pendingPlan;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkSiteRequest)) {
            return false;
        }
        CreateNetworkSiteRequest other = (CreateNetworkSiteRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.networkSiteName(), other.networkSiteName()) && Objects.equals(this.pendingPlan(), other.pendingPlan()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkSiteRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("NetworkArn", (Object)this.networkArn()).add("NetworkSiteName", (Object)this.networkSiteName()).add("PendingPlan", (Object)this.pendingPlan()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "networkSiteName": {
                return Optional.ofNullable(clazz.cast(this.networkSiteName()));
            }
            case "pendingPlan": {
                return Optional.ofNullable(clazz.cast(this.pendingPlan()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkSiteRequest, T> g) {
        return obj -> g.apply((CreateNetworkSiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private String clientToken;
        private String description;
        private String networkArn;
        private String networkSiteName;
        private SitePlan pendingPlan;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkSiteRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.networkArn(model.networkArn);
            this.networkSiteName(model.networkSiteName);
            this.pendingPlan(model.pendingPlan);
            this.tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkSiteName() {
            return this.networkSiteName;
        }

        public final void setNetworkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
        }

        @Override
        public final Builder networkSiteName(String networkSiteName) {
            this.networkSiteName = networkSiteName;
            return this;
        }

        public final SitePlan.Builder getPendingPlan() {
            return this.pendingPlan != null ? this.pendingPlan.toBuilder() : null;
        }

        public final void setPendingPlan(SitePlan.BuilderImpl pendingPlan) {
            this.pendingPlan = pendingPlan != null ? pendingPlan.build() : null;
        }

        @Override
        public final Builder pendingPlan(SitePlan pendingPlan) {
            this.pendingPlan = pendingPlan;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkSiteRequest build() {
            return new CreateNetworkSiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkSiteRequest> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder networkArn(String var1);

        public Builder networkSiteName(String var1);

        public Builder pendingPlan(SitePlan var1);

        default public Builder pendingPlan(Consumer<SitePlan.Builder> pendingPlan) {
            return this.pendingPlan((SitePlan)((SitePlan.Builder)SitePlan.builder().applyMutation(pendingPlan)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

