/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeactivateDeviceIdentifierRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<DeactivateDeviceIdentifierRequest.Builder, DeactivateDeviceIdentifierRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(DeactivateDeviceIdentifierRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DEVICE_IDENTIFIER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceIdentifierArn").getter(getter(DeactivateDeviceIdentifierRequest::deviceIdentifierArn))
            .setter(setter(Builder::deviceIdentifierArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifierArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DEVICE_IDENTIFIER_ARN_FIELD));

    private final String clientToken;

    private final String deviceIdentifierArn;

    private DeactivateDeviceIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deviceIdentifierArn = builder.deviceIdentifierArn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to ensure idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device identifier.
     */
    public final String deviceIdentifierArn() {
        return deviceIdentifierArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIdentifierArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivateDeviceIdentifierRequest)) {
            return false;
        }
        DeactivateDeviceIdentifierRequest other = (DeactivateDeviceIdentifierRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(deviceIdentifierArn(), other.deviceIdentifierArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeactivateDeviceIdentifierRequest").add("ClientToken", clientToken())
                .add("DeviceIdentifierArn", deviceIdentifierArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deviceIdentifierArn":
            return Optional.ofNullable(clazz.cast(deviceIdentifierArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeactivateDeviceIdentifierRequest, T> g) {
        return obj -> g.apply((DeactivateDeviceIdentifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeactivateDeviceIdentifierRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device identifier.
         * </p>
         * 
         * @param deviceIdentifierArn
         *        The Amazon Resource Name (ARN) of the device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIdentifierArn(String deviceIdentifierArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String deviceIdentifierArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivateDeviceIdentifierRequest model) {
            super(model);
            clientToken(model.clientToken);
            deviceIdentifierArn(model.deviceIdentifierArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceIdentifierArn() {
            return deviceIdentifierArn;
        }

        public final void setDeviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
        }

        @Override
        public final Builder deviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeactivateDeviceIdentifierRequest build() {
            return new DeactivateDeviceIdentifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
