/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureAccessPointResponse extends PrivateNetworksResponse implements
        ToCopyableBuilder<ConfigureAccessPointResponse.Builder, ConfigureAccessPointResponse> {
    private static final SdkField<NetworkResource> ACCESS_POINT_FIELD = SdkField
            .<NetworkResource> builder(MarshallingType.SDK_POJO).memberName("accessPoint")
            .getter(getter(ConfigureAccessPointResponse::accessPoint)).setter(setter(Builder::accessPoint))
            .constructor(NetworkResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_FIELD));

    private final NetworkResource accessPoint;

    private ConfigureAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.accessPoint = builder.accessPoint;
    }

    /**
     * <p>
     * Information about the network resource.
     * </p>
     * 
     * @return Information about the network resource.
     */
    public final NetworkResource accessPoint() {
        return accessPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAccessPointResponse)) {
            return false;
        }
        ConfigureAccessPointResponse other = (ConfigureAccessPointResponse) obj;
        return Objects.equals(accessPoint(), other.accessPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureAccessPointResponse").add("AccessPoint", accessPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPoint":
            return Optional.ofNullable(clazz.cast(accessPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAccessPointResponse, T> g) {
        return obj -> g.apply((ConfigureAccessPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureAccessPointResponse> {
        /**
         * <p>
         * Information about the network resource.
         * </p>
         * 
         * @param accessPoint
         *        Information about the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoint(NetworkResource accessPoint);

        /**
         * <p>
         * Information about the network resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkResource.Builder} avoiding the
         * need to create one manually via {@link NetworkResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkResource.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPoint(NetworkResource)}.
         * 
         * @param accessPoint
         *        a consumer that will call methods on {@link NetworkResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPoint(NetworkResource)
         */
        default Builder accessPoint(Consumer<NetworkResource.Builder> accessPoint) {
            return accessPoint(NetworkResource.builder().applyMutation(accessPoint).build());
        }
    }

    static final class BuilderImpl extends PrivateNetworksResponse.BuilderImpl implements Builder {
        private NetworkResource accessPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAccessPointResponse model) {
            super(model);
            accessPoint(model.accessPoint);
        }

        public final NetworkResource.Builder getAccessPoint() {
            return accessPoint != null ? accessPoint.toBuilder() : null;
        }

        public final void setAccessPoint(NetworkResource.BuilderImpl accessPoint) {
            this.accessPoint = accessPoint != null ? accessPoint.build() : null;
        }

        @Override
        public final Builder accessPoint(NetworkResource accessPoint) {
            this.accessPoint = accessPoint;
            return this;
        }

        @Override
        public ConfigureAccessPointResponse build() {
            return new ConfigureAccessPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
