/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworkSitesRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<ListNetworkSitesRequest.Builder, ListNetworkSitesRequest> {
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("filters")
            .getter(getter(ListNetworkSitesRequest::filtersAsStrings))
            .setter(setter(Builder::filtersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListNetworkSitesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkArn").getter(getter(ListNetworkSitesRequest::networkArn)).setter(setter(Builder::networkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()).build();

    private static final SdkField<String> START_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startToken").getter(getter(ListNetworkSitesRequest::startToken)).setter(setter(Builder::startToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NETWORK_ARN_FIELD, START_TOKEN_FIELD));

    private final Map<String, List<String>> filters;

    private final Integer maxResults;

    private final String networkArn;

    private final String startToken;

    private ListNetworkSitesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.networkArn = builder.networkArn;
        this.startToken = builder.startToken;
    }

    /**
     * <p>
     * The filters. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network sites.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
     * <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters. Add filters to your request to return a more specific list of results. Use filters to match
     *         the status of the network sites.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
     *         <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final Map<NetworkSiteFilterKeys, List<String>> filters() {
        return NetworkSiteFiltersCopier.copyStringToEnum(filters);
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The filters. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network sites.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
     * <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
     * <code>OR</code>, and the request returns all results that match any of the specified values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters. Add filters to your request to return a more specific list of results. Use filters to match
     *         the status of the network sites.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
     *         <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with
     *         an <code>OR</code>, and the request returns all results that match any of the specified values.
     */
    public final Map<String, List<String>> filtersAsStrings() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network.
     */
    public final String networkArn() {
        return networkArn;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String startToken() {
        return startToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filtersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(startToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkSitesRequest)) {
            return false;
        }
        ListNetworkSitesRequest other = (ListNetworkSitesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filtersAsStrings(), other.filtersAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(networkArn(), other.networkArn())
                && Objects.equals(startToken(), other.startToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNetworkSitesRequest").add("Filters", hasFilters() ? filtersAsStrings() : null)
                .add("MaxResults", maxResults()).add("NetworkArn", networkArn()).add("StartToken", startToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filtersAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "networkArn":
            return Optional.ofNullable(clazz.cast(networkArn()));
        case "startToken":
            return Optional.ofNullable(clazz.cast(startToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkSitesRequest, T> g) {
        return obj -> g.apply((ListNetworkSitesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListNetworkSitesRequest> {
        /**
         * <p>
         * The filters. Add filters to your request to return a more specific list of results. Use filters to match the
         * status of the network sites.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
         * <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param filters
         *        The filters. Add filters to your request to return a more specific list of results. Use filters to
         *        match the status of the network sites.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code>
         *        | <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters);

        /**
         * <p>
         * The filters. Add filters to your request to return a more specific list of results. Use filters to match the
         * status of the network sites.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code> |
         * <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Filter values are case sensitive. If you specify multiple values for a filter, the values are joined with an
         * <code>OR</code>, and the request returns all results that match any of the specified values.
         * </p>
         * 
         * @param filters
         *        The filters. Add filters to your request to return a more specific list of results. Use filters to
         *        match the status of the network sites.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STATUS</code> - The status (<code>AVAILABLE</code> | <code>CREATED</code> | <code>DELETED</code>
         *        | <code>DEPROVISIONING</code> | <code>PROVISIONING</code>).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Filter values are case sensitive. If you specify multiple values for a filter, the values are joined
         *        with an <code>OR</code>, and the request returns all results that match any of the specified values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<NetworkSiteFilterKeys, ? extends Collection<String>> filters);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network.
         * </p>
         * 
         * @param networkArn
         *        The Amazon Resource Name (ARN) of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkArn(String networkArn);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param startToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToken(String startToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String networkArn;

        private String startToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkSitesRequest model) {
            super(model);
            filtersWithStrings(model.filters);
            maxResults(model.maxResults);
            networkArn(model.networkArn);
            startToken(model.startToken);
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = NetworkSiteFiltersCopier.copy(filters);
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = NetworkSiteFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<NetworkSiteFilterKeys, ? extends Collection<String>> filters) {
            this.filters = NetworkSiteFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNetworkArn() {
            return networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getStartToken() {
            return startToken;
        }

        public final void setStartToken(String startToken) {
            this.startToken = startToken;
        }

        @Override
        public final Builder startToken(String startToken) {
            this.startToken = startToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNetworkSitesRequest build() {
            return new ListNetworkSitesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
