/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNetworkResourceUpdateRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<StartNetworkResourceUpdateRequest.Builder, StartNetworkResourceUpdateRequest> {
    private static final SdkField<String> NETWORK_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkResourceArn").getter(getter(StartNetworkResourceUpdateRequest::networkResourceArn))
            .setter(setter(Builder::networkResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResourceArn").build())
            .build();

    private static final SdkField<String> RETURN_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("returnReason").getter(getter(StartNetworkResourceUpdateRequest::returnReason))
            .setter(setter(Builder::returnReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnReason").build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("shippingAddress").getter(getter(StartNetworkResourceUpdateRequest::shippingAddress))
            .setter(setter(Builder::shippingAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(StartNetworkResourceUpdateRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCE_ARN_FIELD,
            RETURN_REASON_FIELD, SHIPPING_ADDRESS_FIELD, UPDATE_TYPE_FIELD));

    private final String networkResourceArn;

    private final String returnReason;

    private final Address shippingAddress;

    private final String updateType;

    private StartNetworkResourceUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.networkResourceArn = builder.networkResourceArn;
        this.returnReason = builder.returnReason;
        this.shippingAddress = builder.shippingAddress;
        this.updateType = builder.updateType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network resource.
     */
    public final String networkResourceArn() {
        return networkResourceArn;
    }

    /**
     * <p>
     * The reason for the return. Providing a reason for a return is optional.
     * </p>
     * 
     * @return The reason for the return. Providing a reason for a return is optional.
     */
    public final String returnReason() {
        return returnReason;
    }

    /**
     * <p>
     * The shipping address. If you don't provide a shipping address when replacing or returning a network resource, we
     * use the address from the original order for the network resource.
     * </p>
     * 
     * @return The shipping address. If you don't provide a shipping address when replacing or returning a network
     *         resource, we use the address from the original order for the network resource.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * The update type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label that you
     * can use for the return process and we ship a replacement radio unit to you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a shipping
     * label that you can use for the return process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label
     *         that you can use for the return process and we ship a replacement radio unit to you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
     *         shipping label that you can use for the return process.
     *         </p>
     *         </li>
     * @see UpdateType
     */
    public final UpdateType updateType() {
        return UpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The update type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label that you
     * can use for the return process and we ship a replacement radio unit to you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a shipping
     * label that you can use for the return process.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The update type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label
     *         that you can use for the return process and we ship a replacement radio unit to you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
     *         shipping label that you can use for the return process.
     *         </p>
     *         </li>
     * @see UpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(returnReason());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNetworkResourceUpdateRequest)) {
            return false;
        }
        StartNetworkResourceUpdateRequest other = (StartNetworkResourceUpdateRequest) obj;
        return Objects.equals(networkResourceArn(), other.networkResourceArn())
                && Objects.equals(returnReason(), other.returnReason())
                && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartNetworkResourceUpdateRequest").add("NetworkResourceArn", networkResourceArn())
                .add("ReturnReason", returnReason()).add("ShippingAddress", shippingAddress())
                .add("UpdateType", updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkResourceArn":
            return Optional.ofNullable(clazz.cast(networkResourceArn()));
        case "returnReason":
            return Optional.ofNullable(clazz.cast(returnReason()));
        case "shippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNetworkResourceUpdateRequest, T> g) {
        return obj -> g.apply((StartNetworkResourceUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartNetworkResourceUpdateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network resource.
         * </p>
         * 
         * @param networkResourceArn
         *        The Amazon Resource Name (ARN) of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkResourceArn(String networkResourceArn);

        /**
         * <p>
         * The reason for the return. Providing a reason for a return is optional.
         * </p>
         * 
         * @param returnReason
         *        The reason for the return. Providing a reason for a return is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnReason(String returnReason);

        /**
         * <p>
         * The shipping address. If you don't provide a shipping address when replacing or returning a network resource,
         * we use the address from the original order for the network resource.
         * </p>
         * 
         * @param shippingAddress
         *        The shipping address. If you don't provide a shipping address when replacing or returning a network
         *        resource, we use the address from the original order for the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The shipping address. If you don't provide a shipping address when replacing or returning a network resource,
         * we use the address from the original order for the network resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * The update type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label that
         * you can use for the return process and we ship a replacement radio unit to you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
         * shipping label that you can use for the return process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateType
         *        The update type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping
         *        label that you can use for the return process and we ship a replacement radio unit to you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
         *        shipping label that you can use for the return process.
         *        </p>
         *        </li>
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The update type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping label that
         * you can use for the return process and we ship a replacement radio unit to you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
         * shipping label that you can use for the return process.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateType
         *        The update type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Submits a request to replace a defective radio unit. We provide a shipping
         *        label that you can use for the return process and we ship a replacement radio unit to you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETURN</code> - Submits a request to replace a radio unit that you no longer need. We provide a
         *        shipping label that you can use for the return process.
         *        </p>
         *        </li>
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(UpdateType updateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String networkResourceArn;

        private String returnReason;

        private Address shippingAddress;

        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNetworkResourceUpdateRequest model) {
            super(model);
            networkResourceArn(model.networkResourceArn);
            returnReason(model.returnReason);
            shippingAddress(model.shippingAddress);
            updateType(model.updateType);
        }

        public final String getNetworkResourceArn() {
            return networkResourceArn;
        }

        public final void setNetworkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
        }

        @Override
        public final Builder networkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
            return this;
        }

        public final String getReturnReason() {
            return returnReason;
        }

        public final void setReturnReason(String returnReason) {
            this.returnReason = returnReason;
        }

        @Override
        public final Builder returnReason(String returnReason) {
            this.returnReason = returnReason;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNetworkResourceUpdateRequest build() {
            return new StartNetworkResourceUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
