/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksAsyncClient;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse;
import software.amazon.awssdk.services.privatenetworks.model.NetworkSite;

public class ListNetworkSitesPublisher
implements SdkPublisher<ListNetworkSitesResponse> {
    private final PrivateNetworksAsyncClient client;
    private final ListNetworkSitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworkSitesPublisher(PrivateNetworksAsyncClient client, ListNetworkSitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworkSitesPublisher(PrivateNetworksAsyncClient client, ListNetworkSitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworkSitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworkSitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkSite> networkSites() {
        Function<ListNetworkSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkSites() != null) {
                return response.networkSites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNetworkSitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNetworkSitesResponseFetcher
    implements AsyncPageFetcher<ListNetworkSitesResponse> {
        private ListNetworkSitesResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworkSitesResponse> nextPage(ListNetworkSitesResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkSitesPublisher.this.client.listNetworkSites(ListNetworkSitesPublisher.this.firstRequest);
            }
            return ListNetworkSitesPublisher.this.client.listNetworkSites((ListNetworkSitesRequest)((Object)ListNetworkSitesPublisher.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

