/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivateNetworkSiteRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<ActivateNetworkSiteRequest.Builder, ActivateNetworkSiteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(ActivateNetworkSiteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSiteArn").getter(getter(ActivateNetworkSiteRequest::networkSiteArn))
            .setter(setter(Builder::networkSiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("shippingAddress").getter(getter(ActivateNetworkSiteRequest::shippingAddress))
            .setter(setter(Builder::shippingAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NETWORK_SITE_ARN_FIELD, SHIPPING_ADDRESS_FIELD));

    private final String clientToken;

    private final String networkSiteArn;

    private final Address shippingAddress;

    private ActivateNetworkSiteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.networkSiteArn = builder.networkSiteArn;
        this.shippingAddress = builder.shippingAddress;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to ensure idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network site.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network site.
     */
    public final String networkSiteArn() {
        return networkSiteArn;
    }

    /**
     * <p>
     * The shipping address of the network site.
     * </p>
     * 
     * @return The shipping address of the network site.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateNetworkSiteRequest)) {
            return false;
        }
        ActivateNetworkSiteRequest other = (ActivateNetworkSiteRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(networkSiteArn(), other.networkSiteArn())
                && Objects.equals(shippingAddress(), other.shippingAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivateNetworkSiteRequest").add("ClientToken", clientToken())
                .add("NetworkSiteArn", networkSiteArn()).add("ShippingAddress", shippingAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "networkSiteArn":
            return Optional.ofNullable(clazz.cast(networkSiteArn()));
        case "shippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateNetworkSiteRequest, T> g) {
        return obj -> g.apply((ActivateNetworkSiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ActivateNetworkSiteRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network site.
         * </p>
         * 
         * @param networkSiteArn
         *        The Amazon Resource Name (ARN) of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSiteArn(String networkSiteArn);

        /**
         * <p>
         * The shipping address of the network site.
         * </p>
         * 
         * @param shippingAddress
         *        The shipping address of the network site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The shipping address of the network site.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String networkSiteArn;

        private Address shippingAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateNetworkSiteRequest model) {
            super(model);
            clientToken(model.clientToken);
            networkSiteArn(model.networkSiteArn);
            shippingAddress(model.shippingAddress);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getNetworkSiteArn() {
            return networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateNetworkSiteRequest build() {
            return new ActivateNetworkSiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
