/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.Position;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureAccessPointRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, ConfigureAccessPointRequest> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPointArn").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::accessPointArn)).setter(ConfigureAccessPointRequest.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointArn").build()}).build();
    private static final SdkField<String> CPI_SECRET_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpiSecretKey").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::cpiSecretKey)).setter(ConfigureAccessPointRequest.setter(Builder::cpiSecretKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiSecretKey").build()}).build();
    private static final SdkField<String> CPI_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpiUserId").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::cpiUserId)).setter(ConfigureAccessPointRequest.setter(Builder::cpiUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUserId").build()}).build();
    private static final SdkField<String> CPI_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpiUserPassword").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::cpiUserPassword)).setter(ConfigureAccessPointRequest.setter(Builder::cpiUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUserPassword").build()}).build();
    private static final SdkField<String> CPI_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpiUsername").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::cpiUsername)).setter(ConfigureAccessPointRequest.setter(Builder::cpiUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUsername").build()}).build();
    private static final SdkField<Position> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("position").getter(ConfigureAccessPointRequest.getter(ConfigureAccessPointRequest::position)).setter(ConfigureAccessPointRequest.setter(Builder::position)).constructor(Position::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD, CPI_SECRET_KEY_FIELD, CPI_USER_ID_FIELD, CPI_USER_PASSWORD_FIELD, CPI_USERNAME_FIELD, POSITION_FIELD));
    private final String accessPointArn;
    private final String cpiSecretKey;
    private final String cpiUserId;
    private final String cpiUserPassword;
    private final String cpiUsername;
    private final Position position;

    private ConfigureAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.accessPointArn = builder.accessPointArn;
        this.cpiSecretKey = builder.cpiSecretKey;
        this.cpiUserId = builder.cpiUserId;
        this.cpiUserPassword = builder.cpiUserPassword;
        this.cpiUsername = builder.cpiUsername;
        this.position = builder.position;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final String cpiSecretKey() {
        return this.cpiSecretKey;
    }

    public final String cpiUserId() {
        return this.cpiUserId;
    }

    public final String cpiUserPassword() {
        return this.cpiUserPassword;
    }

    public final String cpiUsername() {
        return this.cpiUsername;
    }

    public final Position position() {
        return this.position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpiSecretKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpiUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpiUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpiUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAccessPointRequest)) {
            return false;
        }
        ConfigureAccessPointRequest other = (ConfigureAccessPointRequest)((Object)obj);
        return Objects.equals(this.accessPointArn(), other.accessPointArn()) && Objects.equals(this.cpiSecretKey(), other.cpiSecretKey()) && Objects.equals(this.cpiUserId(), other.cpiUserId()) && Objects.equals(this.cpiUserPassword(), other.cpiUserPassword()) && Objects.equals(this.cpiUsername(), other.cpiUsername()) && Objects.equals(this.position(), other.position());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureAccessPointRequest").add("AccessPointArn", (Object)this.accessPointArn()).add("CpiSecretKey", (Object)(this.cpiSecretKey() == null ? null : "*** Sensitive Data Redacted ***")).add("CpiUserId", (Object)(this.cpiUserId() == null ? null : "*** Sensitive Data Redacted ***")).add("CpiUserPassword", (Object)(this.cpiUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CpiUsername", (Object)(this.cpiUsername() == null ? null : "*** Sensitive Data Redacted ***")).add("Position", (Object)this.position()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "cpiSecretKey": {
                return Optional.ofNullable(clazz.cast(this.cpiSecretKey()));
            }
            case "cpiUserId": {
                return Optional.ofNullable(clazz.cast(this.cpiUserId()));
            }
            case "cpiUserPassword": {
                return Optional.ofNullable(clazz.cast(this.cpiUserPassword()));
            }
            case "cpiUsername": {
                return Optional.ofNullable(clazz.cast(this.cpiUsername()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAccessPointRequest, T> g) {
        return obj -> g.apply((ConfigureAccessPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String accessPointArn;
        private String cpiSecretKey;
        private String cpiUserId;
        private String cpiUserPassword;
        private String cpiUsername;
        private Position position;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAccessPointRequest model) {
            super(model);
            this.accessPointArn(model.accessPointArn);
            this.cpiSecretKey(model.cpiSecretKey);
            this.cpiUserId(model.cpiUserId);
            this.cpiUserPassword(model.cpiUserPassword);
            this.cpiUsername(model.cpiUsername);
            this.position(model.position);
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getCpiSecretKey() {
            return this.cpiSecretKey;
        }

        public final void setCpiSecretKey(String cpiSecretKey) {
            this.cpiSecretKey = cpiSecretKey;
        }

        @Override
        public final Builder cpiSecretKey(String cpiSecretKey) {
            this.cpiSecretKey = cpiSecretKey;
            return this;
        }

        public final String getCpiUserId() {
            return this.cpiUserId;
        }

        public final void setCpiUserId(String cpiUserId) {
            this.cpiUserId = cpiUserId;
        }

        @Override
        public final Builder cpiUserId(String cpiUserId) {
            this.cpiUserId = cpiUserId;
            return this;
        }

        public final String getCpiUserPassword() {
            return this.cpiUserPassword;
        }

        public final void setCpiUserPassword(String cpiUserPassword) {
            this.cpiUserPassword = cpiUserPassword;
        }

        @Override
        public final Builder cpiUserPassword(String cpiUserPassword) {
            this.cpiUserPassword = cpiUserPassword;
            return this;
        }

        public final String getCpiUsername() {
            return this.cpiUsername;
        }

        public final void setCpiUsername(String cpiUsername) {
            this.cpiUsername = cpiUsername;
        }

        @Override
        public final Builder cpiUsername(String cpiUsername) {
            this.cpiUsername = cpiUsername;
            return this;
        }

        public final Position.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(Position.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Position position) {
            this.position = position;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureAccessPointRequest build() {
            return new ConfigureAccessPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureAccessPointRequest> {
        public Builder accessPointArn(String var1);

        public Builder cpiSecretKey(String var1);

        public Builder cpiUserId(String var1);

        public Builder cpiUserPassword(String var1);

        public Builder cpiUsername(String var1);

        public Builder position(Position var1);

        default public Builder position(Consumer<Position.Builder> position) {
            return this.position((Position)((Position.Builder)Position.builder().applyMutation(position)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

