/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest;
import software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptResponse;
import software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointRequest;
import software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest;
import software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse;
import software.amazon.awssdk.services.privatenetworks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.PingRequest;
import software.amazon.awssdk.services.privatenetworks.model.PingResponse;
import software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.TagResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.UntagResourceRequest;
import software.amazon.awssdk.services.privatenetworks.model.UntagResourceResponse;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanResponse;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest;
import software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteResponse;
import software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersPublisher;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesPublisher;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesPublisher;
import software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksPublisher;
import software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersPublisher;

/**
 * Service client for accessing AWS Private 5G asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services Private 5G is a managed service that makes it easy to deploy, operate, and scale your own private
 * mobile network at your on-premises location. Private 5G provides the pre-configured hardware and software for mobile
 * networks, helps automate setup, and scales capacity on demand to support additional devices as needed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PrivateNetworksAsyncClient extends SdkClient {
    String SERVICE_NAME = "private-networks";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "private-networks";

    /**
     * <p>
     * Acknowledges that the specified network order was received.
     * </p>
     *
     * @param acknowledgeOrderReceiptRequest
     * @return A Java Future containing the result of the AcknowledgeOrderReceipt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.AcknowledgeOrderReceipt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcknowledgeOrderReceiptResponse> acknowledgeOrderReceipt(
            AcknowledgeOrderReceiptRequest acknowledgeOrderReceiptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Acknowledges that the specified network order was received.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcknowledgeOrderReceiptRequest.Builder} avoiding
     * the need to create one manually via {@link AcknowledgeOrderReceiptRequest#builder()}
     * </p>
     *
     * @param acknowledgeOrderReceiptRequest
     *        A {@link Consumer} that will call methods on {@link AcknowledgeOrderReceiptRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcknowledgeOrderReceipt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.AcknowledgeOrderReceipt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/AcknowledgeOrderReceipt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcknowledgeOrderReceiptResponse> acknowledgeOrderReceipt(
            Consumer<AcknowledgeOrderReceiptRequest.Builder> acknowledgeOrderReceiptRequest) {
        return acknowledgeOrderReceipt(AcknowledgeOrderReceiptRequest.builder().applyMutation(acknowledgeOrderReceiptRequest)
                .build());
    }

    /**
     * <p>
     * Activates the specified device identifier.
     * </p>
     *
     * @param activateDeviceIdentifierRequest
     * @return A Java Future containing the result of the ActivateDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ActivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateDeviceIdentifierResponse> activateDeviceIdentifier(
            ActivateDeviceIdentifierRequest activateDeviceIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateDeviceIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link ActivateDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param activateDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link ActivateDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ActivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateDeviceIdentifierResponse> activateDeviceIdentifier(
            Consumer<ActivateDeviceIdentifierRequest.Builder> activateDeviceIdentifierRequest) {
        return activateDeviceIdentifier(ActivateDeviceIdentifierRequest.builder().applyMutation(activateDeviceIdentifierRequest)
                .build());
    }

    /**
     * <p>
     * Activates the specified network site.
     * </p>
     *
     * @param activateNetworkSiteRequest
     * @return A Java Future containing the result of the ActivateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ActivateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateNetworkSiteResponse> activateNetworkSite(
            ActivateNetworkSiteRequest activateNetworkSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateNetworkSiteRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param activateNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link ActivateNetworkSiteRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ActivateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ActivateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateNetworkSiteResponse> activateNetworkSite(
            Consumer<ActivateNetworkSiteRequest.Builder> activateNetworkSiteRequest) {
        return activateNetworkSite(ActivateNetworkSiteRequest.builder().applyMutation(activateNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Configures the specified network resource.
     * </p>
     * <p>
     * Use this action to specify the geographic position of the hardware. You must provide Certified Professional
     * Installer (CPI) credentials in the request so that we can obtain spectrum grants. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html">Radio units</a> in the
     * <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     *
     * @param configureAccessPointRequest
     * @return A Java Future containing the result of the ConfigureAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ConfigureAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfigureAccessPointResponse> configureAccessPoint(
            ConfigureAccessPointRequest configureAccessPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the specified network resource.
     * </p>
     * <p>
     * Use this action to specify the geographic position of the hardware. You must provide Certified Professional
     * Installer (CPI) credentials in the request so that we can obtain spectrum grants. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html">Radio units</a> in the
     * <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureAccessPointRequest.Builder} avoiding the
     * need to create one manually via {@link ConfigureAccessPointRequest#builder()}
     * </p>
     *
     * @param configureAccessPointRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureAccessPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ConfigureAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ConfigureAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ConfigureAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfigureAccessPointResponse> configureAccessPoint(
            Consumer<ConfigureAccessPointRequest.Builder> configureAccessPointRequest) {
        return configureAccessPoint(ConfigureAccessPointRequest.builder().applyMutation(configureAccessPointRequest).build());
    }

    /**
     * <p>
     * Creates a network.
     * </p>
     *
     * @param createNetworkRequest
     * @return A Java Future containing the result of the CreateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The limit was exceeded.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkResponse> createNetwork(CreateNetworkRequest createNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNetworkRequest#builder()}
     * </p>
     *
     * @param createNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The limit was exceeded.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNetworkResponse> createNetwork(Consumer<CreateNetworkRequest.Builder> createNetworkRequest) {
        return createNetwork(CreateNetworkRequest.builder().applyMutation(createNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a network site.
     * </p>
     *
     * @param createNetworkSiteRequest
     * @return A Java Future containing the result of the CreateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.CreateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkSiteResponse> createNetworkSite(CreateNetworkSiteRequest createNetworkSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param createNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.CreateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/CreateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkSiteResponse> createNetworkSite(
            Consumer<CreateNetworkSiteRequest.Builder> createNetworkSiteRequest) {
        return createNetworkSite(CreateNetworkSiteRequest.builder().applyMutation(createNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Deactivates the specified device identifier.
     * </p>
     *
     * @param deactivateDeviceIdentifierRequest
     * @return A Java Future containing the result of the DeactivateDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeactivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateDeviceIdentifierResponse> deactivateDeviceIdentifier(
            DeactivateDeviceIdentifierRequest deactivateDeviceIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateDeviceIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param deactivateDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeactivateDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeactivateDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateDeviceIdentifierResponse> deactivateDeviceIdentifier(
            Consumer<DeactivateDeviceIdentifierRequest.Builder> deactivateDeviceIdentifierRequest) {
        return deactivateDeviceIdentifier(DeactivateDeviceIdentifierRequest.builder()
                .applyMutation(deactivateDeviceIdentifierRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network. You must delete network sites before you delete the network. For more information,
     * see <a href="https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html">
     * DeleteNetworkSite</a> in the <i>API Reference for Amazon Web Services Private 5G</i>.
     * </p>
     *
     * @param deleteNetworkRequest
     * @return A Java Future containing the result of the DeleteNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkResponse> deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network. You must delete network sites before you delete the network. For more information,
     * see <a href="https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html">
     * DeleteNetworkSite</a> in the <i>API Reference for Amazon Web Services Private 5G</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNetworkRequest#builder()}
     * </p>
     *
     * @param deleteNetworkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkResponse> deleteNetwork(Consumer<DeleteNetworkRequest.Builder> deleteNetworkRequest) {
        return deleteNetwork(DeleteNetworkRequest.builder().applyMutation(deleteNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network site. Return the hardware after you delete the network site. You are responsible
     * for minimum charges. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/hardware-maintenance.html">Hardware
     * returns</a> in the <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     *
     * @param deleteNetworkSiteRequest
     * @return A Java Future containing the result of the DeleteNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeleteNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkSiteResponse> deleteNetworkSite(DeleteNetworkSiteRequest deleteNetworkSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network site. Return the hardware after you delete the network site. You are responsible
     * for minimum charges. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/hardware-maintenance.html">Hardware
     * returns</a> in the <i>Amazon Web Services Private 5G User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNetworkSiteRequest#builder()}
     * </p>
     *
     * @param deleteNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.DeleteNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/DeleteNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkSiteResponse> deleteNetworkSite(
            Consumer<DeleteNetworkSiteRequest.Builder> deleteNetworkSiteRequest) {
        return deleteNetworkSite(DeleteNetworkSiteRequest.builder().applyMutation(deleteNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Gets the specified device identifier.
     * </p>
     *
     * @param getDeviceIdentifierRequest
     * @return A Java Future containing the result of the GetDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceIdentifierResponse> getDeviceIdentifier(
            GetDeviceIdentifierRequest getDeviceIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified device identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceIdentifierRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceIdentifierRequest#builder()}
     * </p>
     *
     * @param getDeviceIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeviceIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetDeviceIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetDeviceIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeviceIdentifierResponse> getDeviceIdentifier(
            Consumer<GetDeviceIdentifierRequest.Builder> getDeviceIdentifierRequest) {
        return getDeviceIdentifier(GetDeviceIdentifierRequest.builder().applyMutation(getDeviceIdentifierRequest).build());
    }

    /**
     * <p>
     * Gets the specified network.
     * </p>
     *
     * @param getNetworkRequest
     * @return A Java Future containing the result of the GetNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkResponse> getNetwork(GetNetworkRequest getNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkRequest#builder()}
     * </p>
     *
     * @param getNetworkRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkResponse> getNetwork(Consumer<GetNetworkRequest.Builder> getNetworkRequest) {
        return getNetwork(GetNetworkRequest.builder().applyMutation(getNetworkRequest).build());
    }

    /**
     * <p>
     * Gets the specified network resource.
     * </p>
     *
     * @param getNetworkResourceRequest
     * @return A Java Future containing the result of the GetNetworkResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetworkResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceResponse> getNetworkResource(GetNetworkResourceRequest getNetworkResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkResourceRequest#builder()}
     * </p>
     *
     * @param getNetworkResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetworkResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkResourceResponse> getNetworkResource(
            Consumer<GetNetworkResourceRequest.Builder> getNetworkResourceRequest) {
        return getNetworkResource(GetNetworkResourceRequest.builder().applyMutation(getNetworkResourceRequest).build());
    }

    /**
     * <p>
     * Gets the specified network site.
     * </p>
     *
     * @param getNetworkSiteRequest
     * @return A Java Future containing the result of the GetNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkSiteResponse> getNetworkSite(GetNetworkSiteRequest getNetworkSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkSiteRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkSiteRequest#builder()}
     * </p>
     *
     * @param getNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkSiteResponse> getNetworkSite(Consumer<GetNetworkSiteRequest.Builder> getNetworkSiteRequest) {
        return getNetworkSite(GetNetworkSiteRequest.builder().applyMutation(getNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Gets the specified order.
     * </p>
     *
     * @param getOrderRequest
     * @return A Java Future containing the result of the GetOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOrderResponse> getOrder(GetOrderRequest getOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrderRequest.Builder} avoiding the need to
     * create one manually via {@link GetOrderRequest#builder()}
     * </p>
     *
     * @param getOrderRequest
     *        A {@link Consumer} that will call methods on {@link GetOrderRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOrderResponse> getOrder(Consumer<GetOrderRequest.Builder> getOrderRequest) {
        return getOrder(GetOrderRequest.builder().applyMutation(getOrderRequest).build());
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;If you specify multiple filters, filters are joined with an OR, and the request </code>
     * </pre>
     * <p>
     * returns results that match all of the specified filters.
     * </p>
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     * @return A Java Future containing the result of the ListDeviceIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceIdentifiersResponse> listDeviceIdentifiers(
            ListDeviceIdentifiersRequest listDeviceIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;If you specify multiple filters, filters are joined with an OR, and the request </code>
     * </pre>
     * <p>
     * returns results that match all of the specified filters.
     * </p>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceIdentifiersRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceIdentifiersRequest#builder()}
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceIdentifiersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeviceIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceIdentifiersResponse> listDeviceIdentifiers(
            Consumer<ListDeviceIdentifiersRequest.Builder> listDeviceIdentifiersRequest) {
        return listDeviceIdentifiers(ListDeviceIdentifiersRequest.builder().applyMutation(listDeviceIdentifiersRequest).build());
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;If you specify multiple filters, filters are joined with an OR, and the request </code>
     * </pre>
     * <p>
     * returns results that match all of the specified filters.
     * </p>
     * </p><br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersPublisher publisher = client.listDeviceIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersPublisher publisher = client.listDeviceIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersPublisher listDeviceIdentifiersPaginator(
            ListDeviceIdentifiersRequest listDeviceIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists device identifiers. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order, the status of device identifiers, or the ARN of the traffic
     * group.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;If you specify multiple filters, filters are joined with an OR, and the request </code>
     * </pre>
     * <p>
     * returns results that match all of the specified filters.
     * </p>
     * </p><br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersPublisher publisher = client.listDeviceIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListDeviceIdentifiersPublisher publisher = client.listDeviceIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceIdentifiers(software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceIdentifiersRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceIdentifiersRequest#builder()}
     * </p>
     *
     * @param listDeviceIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceIdentifiersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListDeviceIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListDeviceIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceIdentifiersPublisher listDeviceIdentifiersPaginator(
            Consumer<ListDeviceIdentifiersRequest.Builder> listDeviceIdentifiersRequest) {
        return listDeviceIdentifiersPaginator(ListDeviceIdentifiersRequest.builder().applyMutation(listDeviceIdentifiersRequest)
                .build());
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     *
     * @param listNetworkResourcesRequest
     * @return A Java Future containing the result of the ListNetworkResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkResourcesResponse> listNetworkResources(
            ListNetworkResourcesRequest listNetworkResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param listNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNetworkResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkResourcesResponse> listNetworkResources(
            Consumer<ListNetworkResourcesRequest.Builder> listNetworkResourcesRequest) {
        return listNetworkResources(ListNetworkResourcesRequest.builder().applyMutation(listNetworkResourcesRequest).build());
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesPublisher publisher = client.listNetworkResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesPublisher publisher = client.listNetworkResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesPublisher listNetworkResourcesPaginator(ListNetworkResourcesRequest listNetworkResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network resources. Add filters to your request to return a more specific list of results. Use filters to
     * match the Amazon Resource Name (ARN) of an order or the status of network resources.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesPublisher publisher = client.listNetworkResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkResourcesPublisher publisher = client.listNetworkResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkResources(software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkResourcesRequest#builder()}
     * </p>
     *
     * @param listNetworkResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkResourcesPublisher listNetworkResourcesPaginator(
            Consumer<ListNetworkResourcesRequest.Builder> listNetworkResourcesRequest) {
        return listNetworkResourcesPaginator(ListNetworkResourcesRequest.builder().applyMutation(listNetworkResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     *
     * @param listNetworkSitesRequest
     * @return A Java Future containing the result of the ListNetworkSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkSitesResponse> listNetworkSites(ListNetworkSitesRequest listNetworkSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSitesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNetworkSitesRequest#builder()}
     * </p>
     *
     * @param listNetworkSitesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkSitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNetworkSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkSitesResponse> listNetworkSites(
            Consumer<ListNetworkSitesRequest.Builder> listNetworkSitesRequest) {
        return listNetworkSites(ListNetworkSitesRequest.builder().applyMutation(listNetworkSitesRequest).build());
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesPublisher publisher = client.listNetworkSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesPublisher publisher = client.listNetworkSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesPublisher listNetworkSitesPaginator(ListNetworkSitesRequest listNetworkSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network sites. Add filters to your request to return a more specific list of results. Use filters to match
     * the status of the network site.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesPublisher publisher = client.listNetworkSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworkSitesPublisher publisher = client.listNetworkSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSites(software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSitesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNetworkSitesRequest#builder()}
     * </p>
     *
     * @param listNetworkSitesRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworkSitesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworkSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworkSites"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSitesPublisher listNetworkSitesPaginator(Consumer<ListNetworkSitesRequest.Builder> listNetworkSitesRequest) {
        return listNetworkSitesPaginator(ListNetworkSitesRequest.builder().applyMutation(listNetworkSitesRequest).build());
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     *
     * @param listNetworksRequest
     * @return A Java Future containing the result of the ListNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNetworksResponse> listNetworks(ListNetworksRequest listNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNetworksResponse> listNetworks(Consumer<ListNetworksRequest.Builder> listNetworksRequest) {
        return listNetworks(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksPublisher listNetworksPaginator(ListNetworksRequest listNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists networks. Add filters to your request to return a more specific list of results. Use filters to match the
     * status of the network.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListNetworks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNetworksPublisher listNetworksPaginator(Consumer<ListNetworksRequest.Builder> listNetworksRequest) {
        return listNetworksPaginator(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     *
     * @param listOrdersRequest
     * @return A Java Future containing the result of the ListOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrdersResponse> listOrders(ListOrdersRequest listOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListOrdersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrdersResponse> listOrders(Consumer<ListOrdersRequest.Builder> listOrdersRequest) {
        return listOrders(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)} operation.</b>
     * </p>
     *
     * @param listOrdersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersPublisher listOrdersPaginator(ListOrdersRequest listOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists orders. Add filters to your request to return a more specific list of results. Use filters to match the
     * Amazon Resource Name (ARN) of the network site or the status of the order.
     * </p>
     * <p>
     * If you specify multiple filters, filters are joined with an OR, and the request returns results that match all of
     * the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.privatenetworks.paginators.ListOrdersPublisher publisher = client.listOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.privatenetworks.model.ListOrdersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListOrdersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListOrders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrdersPublisher listOrdersPaginator(Consumer<ListOrdersRequest.Builder> listOrdersRequest) {
        return listOrdersPaginator(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Checks the health of the service.
     * </p>
     *
     * @param pingRequest
     * @return A Java Future containing the result of the Ping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.Ping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PingResponse> ping(PingRequest pingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the health of the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PingRequest.Builder} avoiding the need to create
     * one manually via {@link PingRequest#builder()}
     * </p>
     *
     * @param pingRequest
     *        A {@link Consumer} that will call methods on {@link PingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Ping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.Ping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/Ping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PingResponse> ping(Consumer<PingRequest.Builder> pingRequest) {
        return ping(PingRequest.builder().applyMutation(pingRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException You do not have permission to perform this operation.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified network site.
     * </p>
     *
     * @param updateNetworkSiteRequest
     * @return A Java Future containing the result of the UpdateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UpdateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSiteResponse> updateNetworkSite(UpdateNetworkSiteRequest updateNetworkSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified network site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSiteRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNetworkSiteRequest#builder()}
     * </p>
     *
     * @param updateNetworkSiteRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateNetworkSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UpdateNetworkSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSite"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSiteResponse> updateNetworkSite(
            Consumer<UpdateNetworkSiteRequest.Builder> updateNetworkSiteRequest) {
        return updateNetworkSite(UpdateNetworkSiteRequest.builder().applyMutation(updateNetworkSiteRequest).build());
    }

    /**
     * <p>
     * Updates the specified network site plan.
     * </p>
     *
     * @param updateNetworkSitePlanRequest
     * @return A Java Future containing the result of the UpdateNetworkSitePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UpdateNetworkSitePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSitePlanResponse> updateNetworkSitePlan(
            UpdateNetworkSitePlanRequest updateNetworkSitePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified network site plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSitePlanRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkSitePlanRequest#builder()}
     * </p>
     *
     * @param updateNetworkSitePlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkSitePlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNetworkSitePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>ValidationException The request failed validation.</li>
     *         <li>InternalServerException Information about an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PrivateNetworksException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample PrivateNetworksAsyncClient.UpdateNetworkSitePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/privatenetworks-2021-12-03/UpdateNetworkSitePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSitePlanResponse> updateNetworkSitePlan(
            Consumer<UpdateNetworkSitePlanRequest.Builder> updateNetworkSitePlanRequest) {
        return updateNetworkSitePlan(UpdateNetworkSitePlanRequest.builder().applyMutation(updateNetworkSitePlanRequest).build());
    }

    /**
     * Create a {@link PrivateNetworksAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PrivateNetworksAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PrivateNetworksAsyncClient}.
     */
    static PrivateNetworksAsyncClientBuilder builder() {
        return new DefaultPrivateNetworksAsyncClientBuilder();
    }
}
