/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksClient;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse;
import software.amazon.awssdk.services.privatenetworks.model.NetworkSite;

public class ListNetworkSitesIterable
implements SdkIterable<ListNetworkSitesResponse> {
    private final PrivateNetworksClient client;
    private final ListNetworkSitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworkSitesIterable(PrivateNetworksClient client, ListNetworkSitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNetworkSitesResponseFetcher();
    }

    public Iterator<ListNetworkSitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkSite> networkSites() {
        Function<ListNetworkSitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkSites() != null) {
                return response.networkSites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNetworkSitesResponseFetcher
    implements SyncPageFetcher<ListNetworkSitesResponse> {
        private ListNetworkSitesResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkSitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworkSitesResponse nextPage(ListNetworkSitesResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkSitesIterable.this.client.listNetworkSites(ListNetworkSitesIterable.this.firstRequest);
            }
            return ListNetworkSitesIterable.this.client.listNetworkSites((ListNetworkSitesRequest)((Object)ListNetworkSitesIterable.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

