/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcknowledgeOrderReceiptResponse extends PrivateNetworksResponse implements
        ToCopyableBuilder<AcknowledgeOrderReceiptResponse.Builder, AcknowledgeOrderReceiptResponse> {
    private static final SdkField<Order> ORDER_FIELD = SdkField.<Order> builder(MarshallingType.SDK_POJO).memberName("order")
            .getter(getter(AcknowledgeOrderReceiptResponse::order)).setter(setter(Builder::order)).constructor(Order::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_FIELD));

    private final Order order;

    private AcknowledgeOrderReceiptResponse(BuilderImpl builder) {
        super(builder);
        this.order = builder.order;
    }

    /**
     * <p>
     * Information about the order.
     * </p>
     * 
     * @return Information about the order.
     */
    public final Order order() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(order());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeOrderReceiptResponse)) {
            return false;
        }
        AcknowledgeOrderReceiptResponse other = (AcknowledgeOrderReceiptResponse) obj;
        return Objects.equals(order(), other.order());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcknowledgeOrderReceiptResponse").add("Order", order()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "order":
            return Optional.ofNullable(clazz.cast(order()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeOrderReceiptResponse, T> g) {
        return obj -> g.apply((AcknowledgeOrderReceiptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AcknowledgeOrderReceiptResponse> {
        /**
         * <p>
         * Information about the order.
         * </p>
         * 
         * @param order
         *        Information about the order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Order order);

        /**
         * <p>
         * Information about the order.
         * </p>
         * This is a convenience method that creates an instance of the {@link Order.Builder} avoiding the need to
         * create one manually via {@link Order#builder()}.
         *
         * When the {@link Consumer} completes, {@link Order.Builder#build()} is called immediately and its result is
         * passed to {@link #order(Order)}.
         * 
         * @param order
         *        a consumer that will call methods on {@link Order.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #order(Order)
         */
        default Builder order(Consumer<Order.Builder> order) {
            return order(Order.builder().applyMutation(order).build());
        }
    }

    static final class BuilderImpl extends PrivateNetworksResponse.BuilderImpl implements Builder {
        private Order order;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeOrderReceiptResponse model) {
            super(model);
            order(model.order);
        }

        public final Order.Builder getOrder() {
            return order != null ? order.toBuilder() : null;
        }

        public final void setOrder(Order.BuilderImpl order) {
            this.order = order != null ? order.build() : null;
        }

        @Override
        public final Builder order(Order order) {
            this.order = order;
            return this;
        }

        @Override
        public AcknowledgeOrderReceiptResponse build() {
            return new AcknowledgeOrderReceiptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
