/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation;

public class DescribeOptOutListsIterable
implements SdkIterable<DescribeOptOutListsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeOptOutListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOptOutListsIterable(PinpointSmsVoiceV2Client client, DescribeOptOutListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOptOutListsResponseFetcher();
    }

    public Iterator<DescribeOptOutListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OptOutListInformation> optOutLists() {
        Function<DescribeOptOutListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optOutLists() != null) {
                return response.optOutLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOptOutListsResponseFetcher
    implements SyncPageFetcher<DescribeOptOutListsResponse> {
        private DescribeOptOutListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptOutListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOptOutListsResponse nextPage(DescribeOptOutListsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptOutListsIterable.this.client.describeOptOutLists(DescribeOptOutListsIterable.this.firstRequest);
            }
            return DescribeOptOutListsIterable.this.client.describeOptOutLists((DescribeOptOutListsRequest)((Object)DescribeOptOutListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

