/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;

public class DescribeConfigurationSetsPublisher
implements SdkPublisher<DescribeConfigurationSetsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeConfigurationSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigurationSetsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeConfigurationSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigurationSetsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeConfigurationSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigurationSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigurationSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationSetInformation> configurationSets() {
        Function<DescribeConfigurationSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationSets() != null) {
                return response.configurationSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeConfigurationSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeConfigurationSetsResponseFetcher
    implements AsyncPageFetcher<DescribeConfigurationSetsResponse> {
        private DescribeConfigurationSetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigurationSetsResponse> nextPage(DescribeConfigurationSetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationSetsPublisher.this.client.describeConfigurationSets(DescribeConfigurationSetsPublisher.this.firstRequest);
            }
            return DescribeConfigurationSetsPublisher.this.client.describeConfigurationSets((DescribeConfigurationSetsRequest)((Object)DescribeConfigurationSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

