/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LanguageCode {
    DE_DE("DE_DE"),
    EN_GB("EN_GB"),
    EN_US("EN_US"),
    ES_419("ES_419"),
    ES_ES("ES_ES"),
    FR_CA("FR_CA"),
    FR_FR("FR_FR"),
    IT_IT("IT_IT"),
    JA_JP("JA_JP"),
    KO_KR("KO_KR"),
    PT_BR("PT_BR"),
    ZH_CN("ZH_CN"),
    ZH_TW("ZH_TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCode> VALUE_MAP;
    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCode> knownValues() {
        EnumSet<LanguageCode> knownValues = EnumSet.allOf(LanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LanguageCode.class, LanguageCode::toString);
    }
}

