/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldRequirement {
    REQUIRED("REQUIRED"),
    CONDITIONAL("CONDITIONAL"),
    OPTIONAL("OPTIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldRequirement> VALUE_MAP;
    private final String value;

    private FieldRequirement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldRequirement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldRequirement> knownValues() {
        EnumSet<FieldRequirement> knownValues = EnumSet.allOf(FieldRequirement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldRequirement.class, FieldRequirement::toString);
    }
}

