/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition;

public class DescribeRegistrationSectionDefinitionsPublisher
implements SdkPublisher<DescribeRegistrationSectionDefinitionsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationSectionDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationSectionDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationSectionDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationSectionDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationSectionDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationSectionDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationSectionDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationSectionDefinition> registrationSectionDefinitions() {
        Function<DescribeRegistrationSectionDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationSectionDefinitions() != null) {
                return response.registrationSectionDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationSectionDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationSectionDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationSectionDefinitionsResponse> {
        private DescribeRegistrationSectionDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationSectionDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> nextPage(DescribeRegistrationSectionDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationSectionDefinitionsPublisher.this.client.describeRegistrationSectionDefinitions(DescribeRegistrationSectionDefinitionsPublisher.this.firstRequest);
            }
            return DescribeRegistrationSectionDefinitionsPublisher.this.client.describeRegistrationSectionDefinitions((DescribeRegistrationSectionDefinitionsRequest)((Object)DescribeRegistrationSectionDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

