/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SelectChoiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationFieldValueInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrationFieldValueInformation> {
    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldPath").getter(RegistrationFieldValueInformation.getter(RegistrationFieldValueInformation::fieldPath)).setter(RegistrationFieldValueInformation.setter(Builder::fieldPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()}).build();
    private static final SdkField<List<String>> SELECT_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectChoices").getter(RegistrationFieldValueInformation.getter(RegistrationFieldValueInformation::selectChoices)).setter(RegistrationFieldValueInformation.setter(Builder::selectChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextValue").getter(RegistrationFieldValueInformation.getter(RegistrationFieldValueInformation::textValue)).setter(RegistrationFieldValueInformation.setter(Builder::textValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValue").build()}).build();
    private static final SdkField<String> REGISTRATION_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationAttachmentId").getter(RegistrationFieldValueInformation.getter(RegistrationFieldValueInformation::registrationAttachmentId)).setter(RegistrationFieldValueInformation.setter(Builder::registrationAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentId").build()}).build();
    private static final SdkField<String> DENIED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeniedReason").getter(RegistrationFieldValueInformation.getter(RegistrationFieldValueInformation::deniedReason)).setter(RegistrationFieldValueInformation.setter(Builder::deniedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeniedReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_PATH_FIELD, SELECT_CHOICES_FIELD, TEXT_VALUE_FIELD, REGISTRATION_ATTACHMENT_ID_FIELD, DENIED_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldPath;
    private final List<String> selectChoices;
    private final String textValue;
    private final String registrationAttachmentId;
    private final String deniedReason;

    private RegistrationFieldValueInformation(BuilderImpl builder) {
        this.fieldPath = builder.fieldPath;
        this.selectChoices = builder.selectChoices;
        this.textValue = builder.textValue;
        this.registrationAttachmentId = builder.registrationAttachmentId;
        this.deniedReason = builder.deniedReason;
    }

    public final String fieldPath() {
        return this.fieldPath;
    }

    public final boolean hasSelectChoices() {
        return this.selectChoices != null && !(this.selectChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectChoices() {
        return this.selectChoices;
    }

    public final String textValue() {
        return this.textValue;
    }

    public final String registrationAttachmentId() {
        return this.registrationAttachmentId;
    }

    public final String deniedReason() {
        return this.deniedReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectChoices() ? this.selectChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.textValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deniedReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationFieldValueInformation)) {
            return false;
        }
        RegistrationFieldValueInformation other = (RegistrationFieldValueInformation)obj;
        return Objects.equals(this.fieldPath(), other.fieldPath()) && this.hasSelectChoices() == other.hasSelectChoices() && Objects.equals(this.selectChoices(), other.selectChoices()) && Objects.equals(this.textValue(), other.textValue()) && Objects.equals(this.registrationAttachmentId(), other.registrationAttachmentId()) && Objects.equals(this.deniedReason(), other.deniedReason());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrationFieldValueInformation").add("FieldPath", (Object)this.fieldPath()).add("SelectChoices", this.hasSelectChoices() ? this.selectChoices() : null).add("TextValue", (Object)this.textValue()).add("RegistrationAttachmentId", (Object)this.registrationAttachmentId()).add("DeniedReason", (Object)this.deniedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldPath": {
                return Optional.ofNullable(clazz.cast(this.fieldPath()));
            }
            case "SelectChoices": {
                return Optional.ofNullable(clazz.cast(this.selectChoices()));
            }
            case "TextValue": {
                return Optional.ofNullable(clazz.cast(this.textValue()));
            }
            case "RegistrationAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.registrationAttachmentId()));
            }
            case "DeniedReason": {
                return Optional.ofNullable(clazz.cast(this.deniedReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationFieldValueInformation, T> g) {
        return obj -> g.apply((RegistrationFieldValueInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldPath;
        private List<String> selectChoices = DefaultSdkAutoConstructList.getInstance();
        private String textValue;
        private String registrationAttachmentId;
        private String deniedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationFieldValueInformation model) {
            this.fieldPath(model.fieldPath);
            this.selectChoices(model.selectChoices);
            this.textValue(model.textValue);
            this.registrationAttachmentId(model.registrationAttachmentId);
            this.deniedReason(model.deniedReason);
        }

        public final String getFieldPath() {
            return this.fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final Collection<String> getSelectChoices() {
            if (this.selectChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectChoices;
        }

        public final void setSelectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
        }

        @Override
        public final Builder selectChoices(Collection<String> selectChoices) {
            this.selectChoices = SelectChoiceListCopier.copy(selectChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectChoices(String ... selectChoices) {
            this.selectChoices(Arrays.asList(selectChoices));
            return this;
        }

        public final String getTextValue() {
            return this.textValue;
        }

        public final void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        @Override
        public final Builder textValue(String textValue) {
            this.textValue = textValue;
            return this;
        }

        public final String getRegistrationAttachmentId() {
            return this.registrationAttachmentId;
        }

        public final void setRegistrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
        }

        @Override
        public final Builder registrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
            return this;
        }

        public final String getDeniedReason() {
            return this.deniedReason;
        }

        public final void setDeniedReason(String deniedReason) {
            this.deniedReason = deniedReason;
        }

        @Override
        public final Builder deniedReason(String deniedReason) {
            this.deniedReason = deniedReason;
            return this;
        }

        public RegistrationFieldValueInformation build() {
            return new RegistrationFieldValueInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrationFieldValueInformation> {
        public Builder fieldPath(String var1);

        public Builder selectChoices(Collection<String> var1);

        public Builder selectChoices(String ... var1);

        public Builder textValue(String var1);

        public Builder registrationAttachmentId(String var1);

        public Builder deniedReason(String var1);
    }
}

