/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapabilityListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestableNumberType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestPhoneNumberRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, RequestPhoneNumberRequest> {
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::isoCountryCode)).setter(RequestPhoneNumberRequest.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::messageTypeAsString)).setter(RequestPhoneNumberRequest.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberCapabilities").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::numberCapabilitiesAsStrings)).setter(RequestPhoneNumberRequest.setter(Builder::numberCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberType").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::numberTypeAsString)).setter(RequestPhoneNumberRequest.setter(Builder::numberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberType").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::optOutListName)).setter(RequestPhoneNumberRequest.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::poolId)).setter(RequestPhoneNumberRequest.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationId").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::registrationId)).setter(RequestPhoneNumberRequest.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::deletionProtectionEnabled)).setter(RequestPhoneNumberRequest.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::tags)).setter(RequestPhoneNumberRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RequestPhoneNumberRequest.getter(RequestPhoneNumberRequest::clientToken)).setter(RequestPhoneNumberRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPE_FIELD, NUMBER_CAPABILITIES_FIELD, NUMBER_TYPE_FIELD, OPT_OUT_LIST_NAME_FIELD, POOL_ID_FIELD, REGISTRATION_ID_FIELD, DELETION_PROTECTION_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String isoCountryCode;
    private final String messageType;
    private final List<String> numberCapabilities;
    private final String numberType;
    private final String optOutListName;
    private final String poolId;
    private final String registrationId;
    private final Boolean deletionProtectionEnabled;
    private final List<Tag> tags;
    private final String clientToken;

    private RequestPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.isoCountryCode = builder.isoCountryCode;
        this.messageType = builder.messageType;
        this.numberCapabilities = builder.numberCapabilities;
        this.numberType = builder.numberType;
        this.optOutListName = builder.optOutListName;
        this.poolId = builder.poolId;
        this.registrationId = builder.registrationId;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(this.numberCapabilities);
    }

    public final boolean hasNumberCapabilities() {
        return this.numberCapabilities != null && !(this.numberCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> numberCapabilitiesAsStrings() {
        return this.numberCapabilities;
    }

    public final RequestableNumberType numberType() {
        return RequestableNumberType.fromValue(this.numberType);
    }

    public final String numberTypeAsString() {
        return this.numberType;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPhoneNumberRequest)) {
            return false;
        }
        RequestPhoneNumberRequest other = (RequestPhoneNumberRequest)((Object)obj);
        return Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && this.hasNumberCapabilities() == other.hasNumberCapabilities() && Objects.equals(this.numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings()) && Objects.equals(this.numberTypeAsString(), other.numberTypeAsString()) && Objects.equals(this.optOutListName(), other.optOutListName()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"RequestPhoneNumberRequest").add("IsoCountryCode", (Object)this.isoCountryCode()).add("MessageType", (Object)this.messageTypeAsString()).add("NumberCapabilities", this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null).add("NumberType", (Object)this.numberTypeAsString()).add("OptOutListName", (Object)this.optOutListName()).add("PoolId", (Object)this.poolId()).add("RegistrationId", (Object)this.registrationId()).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "NumberCapabilities": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilitiesAsStrings()));
            }
            case "NumberType": {
                return Optional.ofNullable(clazz.cast(this.numberTypeAsString()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "RegistrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "DeletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestPhoneNumberRequest, T> g) {
        return obj -> g.apply((RequestPhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String isoCountryCode;
        private String messageType;
        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();
        private String numberType;
        private String optOutListName;
        private String poolId;
        private String registrationId;
        private Boolean deletionProtectionEnabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestPhoneNumberRequest model) {
            super(model);
            this.isoCountryCode(model.isoCountryCode);
            this.messageType(model.messageType);
            this.numberCapabilitiesWithStrings(model.numberCapabilities);
            this.numberType(model.numberType);
            this.optOutListName(model.optOutListName);
            this.poolId(model.poolId);
            this.registrationId(model.registrationId);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (this.numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String ... numberCapabilities) {
            this.numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability ... numberCapabilities) {
            this.numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getNumberType() {
            return this.numberType;
        }

        public final void setNumberType(String numberType) {
            this.numberType = numberType;
        }

        @Override
        public final Builder numberType(String numberType) {
            this.numberType = numberType;
            return this;
        }

        @Override
        public final Builder numberType(RequestableNumberType numberType) {
            this.numberType(numberType == null ? null : numberType.toString());
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestPhoneNumberRequest build() {
            return new RequestPhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestPhoneNumberRequest> {
        public Builder isoCountryCode(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder numberCapabilitiesWithStrings(Collection<String> var1);

        public Builder numberCapabilitiesWithStrings(String ... var1);

        public Builder numberCapabilities(Collection<NumberCapability> var1);

        public Builder numberCapabilities(NumberCapability ... var1);

        public Builder numberType(String var1);

        public Builder numberType(RequestableNumberType var1);

        public Builder optOutListName(String var1);

        public Builder poolId(String var1);

        public Builder registrationId(String var1);

        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

