/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines a Amazon Pinpoint destination for email events. You can use Amazon Pinpoint events to create
 * attributes in Amazon Pinpoint projects. You can use these attributes to create segments for your campaigns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PinpointDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<PinpointDestination.Builder, PinpointDestination> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PinpointDestination::applicationArn)).setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationArn;

    private PinpointDestination(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.
     */
    public String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinpointDestination)) {
            return false;
        }
        PinpointDestination other = (PinpointDestination) obj;
        return Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PinpointDestination").add("ApplicationArn", applicationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PinpointDestination, T> g) {
        return obj -> g.apply((PinpointDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PinpointDestination> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PinpointDestination model) {
            applicationArn(model.applicationArn);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public PinpointDestination build() {
            return new PinpointDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
