/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the inbox placement data settings for a verified domain that’s associated
 * with your AWS account. This data is available only if you enabled the Deliverability dashboard for the domain (
 * <code>PutDeliverabilityDashboardOption</code> operation).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboxPlacementTrackingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<InboxPlacementTrackingOption.Builder, InboxPlacementTrackingOption> {
    private static final SdkField<Boolean> GLOBAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(InboxPlacementTrackingOption::global)).setter(setter(Builder::global))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Global").build()).build();

    private static final SdkField<List<String>> TRACKED_ISPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InboxPlacementTrackingOption::trackedIsps))
            .setter(setter(Builder::trackedIsps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackedIsps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_FIELD,
            TRACKED_ISPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean global;

    private final List<String> trackedIsps;

    private InboxPlacementTrackingOption(BuilderImpl builder) {
        this.global = builder.global;
        this.trackedIsps = builder.trackedIsps;
    }

    /**
     * <p>
     * Specifies whether inbox placement data is being tracked for the domain.
     * </p>
     * 
     * @return Specifies whether inbox placement data is being tracked for the domain.
     */
    public Boolean global() {
        return global;
    }

    /**
     * <p>
     * An array of strings, one for each major email provider that the inbox placement data applies to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings, one for each major email provider that the inbox placement data applies to.
     */
    public List<String> trackedIsps() {
        return trackedIsps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(global());
        hashCode = 31 * hashCode + Objects.hashCode(trackedIsps());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboxPlacementTrackingOption)) {
            return false;
        }
        InboxPlacementTrackingOption other = (InboxPlacementTrackingOption) obj;
        return Objects.equals(global(), other.global()) && Objects.equals(trackedIsps(), other.trackedIsps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InboxPlacementTrackingOption").add("Global", global()).add("TrackedIsps", trackedIsps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Global":
            return Optional.ofNullable(clazz.cast(global()));
        case "TrackedIsps":
            return Optional.ofNullable(clazz.cast(trackedIsps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InboxPlacementTrackingOption, T> g) {
        return obj -> g.apply((InboxPlacementTrackingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboxPlacementTrackingOption> {
        /**
         * <p>
         * Specifies whether inbox placement data is being tracked for the domain.
         * </p>
         * 
         * @param global
         *        Specifies whether inbox placement data is being tracked for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder global(Boolean global);

        /**
         * <p>
         * An array of strings, one for each major email provider that the inbox placement data applies to.
         * </p>
         * 
         * @param trackedIsps
         *        An array of strings, one for each major email provider that the inbox placement data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackedIsps(Collection<String> trackedIsps);

        /**
         * <p>
         * An array of strings, one for each major email provider that the inbox placement data applies to.
         * </p>
         * 
         * @param trackedIsps
         *        An array of strings, one for each major email provider that the inbox placement data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackedIsps(String... trackedIsps);
    }

    static final class BuilderImpl implements Builder {
        private Boolean global;

        private List<String> trackedIsps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboxPlacementTrackingOption model) {
            global(model.global);
            trackedIsps(model.trackedIsps);
        }

        public final Boolean getGlobal() {
            return global;
        }

        @Override
        public final Builder global(Boolean global) {
            this.global = global;
            return this;
        }

        public final void setGlobal(Boolean global) {
            this.global = global;
        }

        public final Collection<String> getTrackedIsps() {
            return trackedIsps;
        }

        @Override
        public final Builder trackedIsps(Collection<String> trackedIsps) {
            this.trackedIsps = IspNameListCopier.copy(trackedIsps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackedIsps(String... trackedIsps) {
            trackedIsps(Arrays.asList(trackedIsps));
            return this;
        }

        public final void setTrackedIsps(Collection<String> trackedIsps) {
            this.trackedIsps = IspNameListCopier.copy(trackedIsps);
        }

        @Override
        public InboxPlacementTrackingOption build() {
            return new InboxPlacementTrackingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
