/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.services.pinpointemail.model.SendQuota;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetAccountResponse> {
    private static final SdkField<SendQuota> SEND_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetAccountResponse.getter(GetAccountResponse::sendQuota)).setter(GetAccountResponse.setter(Builder::sendQuota)).constructor(SendQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendQuota").build()}).build();
    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetAccountResponse.getter(GetAccountResponse::sendingEnabled)).setter(GetAccountResponse.setter(Builder::sendingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()}).build();
    private static final SdkField<Boolean> DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetAccountResponse.getter(GetAccountResponse::dedicatedIpAutoWarmupEnabled)).setter(GetAccountResponse.setter(Builder::dedicatedIpAutoWarmupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIpAutoWarmupEnabled").build()}).build();
    private static final SdkField<String> ENFORCEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAccountResponse.getter(GetAccountResponse::enforcementStatus)).setter(GetAccountResponse.setter(Builder::enforcementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcementStatus").build()}).build();
    private static final SdkField<Boolean> PRODUCTION_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetAccountResponse.getter(GetAccountResponse::productionAccessEnabled)).setter(GetAccountResponse.setter(Builder::productionAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionAccessEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_QUOTA_FIELD, SENDING_ENABLED_FIELD, DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD, ENFORCEMENT_STATUS_FIELD, PRODUCTION_ACCESS_ENABLED_FIELD));
    private final SendQuota sendQuota;
    private final Boolean sendingEnabled;
    private final Boolean dedicatedIpAutoWarmupEnabled;
    private final String enforcementStatus;
    private final Boolean productionAccessEnabled;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sendQuota = builder.sendQuota;
        this.sendingEnabled = builder.sendingEnabled;
        this.dedicatedIpAutoWarmupEnabled = builder.dedicatedIpAutoWarmupEnabled;
        this.enforcementStatus = builder.enforcementStatus;
        this.productionAccessEnabled = builder.productionAccessEnabled;
    }

    public SendQuota sendQuota() {
        return this.sendQuota;
    }

    public Boolean sendingEnabled() {
        return this.sendingEnabled;
    }

    public Boolean dedicatedIpAutoWarmupEnabled() {
        return this.dedicatedIpAutoWarmupEnabled;
    }

    public String enforcementStatus() {
        return this.enforcementStatus;
    }

    public Boolean productionAccessEnabled() {
        return this.productionAccessEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sendQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedIpAutoWarmupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionAccessEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse)((Object)obj);
        return Objects.equals(this.sendQuota(), other.sendQuota()) && Objects.equals(this.sendingEnabled(), other.sendingEnabled()) && Objects.equals(this.dedicatedIpAutoWarmupEnabled(), other.dedicatedIpAutoWarmupEnabled()) && Objects.equals(this.enforcementStatus(), other.enforcementStatus()) && Objects.equals(this.productionAccessEnabled(), other.productionAccessEnabled());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountResponse").add("SendQuota", (Object)this.sendQuota()).add("SendingEnabled", (Object)this.sendingEnabled()).add("DedicatedIpAutoWarmupEnabled", (Object)this.dedicatedIpAutoWarmupEnabled()).add("EnforcementStatus", (Object)this.enforcementStatus()).add("ProductionAccessEnabled", (Object)this.productionAccessEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendQuota": {
                return Optional.ofNullable(clazz.cast(this.sendQuota()));
            }
            case "SendingEnabled": {
                return Optional.ofNullable(clazz.cast(this.sendingEnabled()));
            }
            case "DedicatedIpAutoWarmupEnabled": {
                return Optional.ofNullable(clazz.cast(this.dedicatedIpAutoWarmupEnabled()));
            }
            case "EnforcementStatus": {
                return Optional.ofNullable(clazz.cast(this.enforcementStatus()));
            }
            case "ProductionAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.productionAccessEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountResponse, T> g) {
        return obj -> g.apply((GetAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private SendQuota sendQuota;
        private Boolean sendingEnabled;
        private Boolean dedicatedIpAutoWarmupEnabled;
        private String enforcementStatus;
        private Boolean productionAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            this.sendQuota(model.sendQuota);
            this.sendingEnabled(model.sendingEnabled);
            this.dedicatedIpAutoWarmupEnabled(model.dedicatedIpAutoWarmupEnabled);
            this.enforcementStatus(model.enforcementStatus);
            this.productionAccessEnabled(model.productionAccessEnabled);
        }

        public final SendQuota.Builder getSendQuota() {
            return this.sendQuota != null ? this.sendQuota.toBuilder() : null;
        }

        @Override
        public final Builder sendQuota(SendQuota sendQuota) {
            this.sendQuota = sendQuota;
            return this;
        }

        public final void setSendQuota(SendQuota.BuilderImpl sendQuota) {
            this.sendQuota = sendQuota != null ? sendQuota.build() : null;
        }

        public final Boolean getSendingEnabled() {
            return this.sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        public final Boolean getDedicatedIpAutoWarmupEnabled() {
            return this.dedicatedIpAutoWarmupEnabled;
        }

        @Override
        public final Builder dedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
            return this;
        }

        public final void setDedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
        }

        public final String getEnforcementStatus() {
            return this.enforcementStatus;
        }

        @Override
        public final Builder enforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
            return this;
        }

        public final void setEnforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
        }

        public final Boolean getProductionAccessEnabled() {
            return this.productionAccessEnabled;
        }

        @Override
        public final Builder productionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
            return this;
        }

        public final void setProductionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountResponse> {
        public Builder sendQuota(SendQuota var1);

        default public Builder sendQuota(Consumer<SendQuota.Builder> sendQuota) {
            return this.sendQuota((SendQuota)((SendQuota.Builder)SendQuota.builder().applyMutation(sendQuota)).build());
        }

        public Builder sendingEnabled(Boolean var1);

        public Builder dedicatedIpAutoWarmupEnabled(Boolean var1);

        public Builder enforcementStatus(String var1);

        public Builder productionAccessEnabled(Boolean var1);
    }
}

