/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.BehaviorOnMxFailure;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEmailIdentityMailFromAttributesRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutEmailIdentityMailFromAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailIdentity").getter(PutEmailIdentityMailFromAttributesRequest.getter(PutEmailIdentityMailFromAttributesRequest::emailIdentity)).setter(PutEmailIdentityMailFromAttributesRequest.setter(Builder::emailIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()}).build();
    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailFromDomain").getter(PutEmailIdentityMailFromAttributesRequest.getter(PutEmailIdentityMailFromAttributesRequest::mailFromDomain)).setter(PutEmailIdentityMailFromAttributesRequest.setter(Builder::mailFromDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()}).build();
    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BehaviorOnMxFailure").getter(PutEmailIdentityMailFromAttributesRequest.getter(PutEmailIdentityMailFromAttributesRequest::behaviorOnMxFailureAsString)).setter(PutEmailIdentityMailFromAttributesRequest.setter(Builder::behaviorOnMxFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMxFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD, MAIL_FROM_DOMAIN_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEmailIdentityMailFromAttributesRequest.memberNameToFieldInitializer();
    private final String emailIdentity;
    private final String mailFromDomain;
    private final String behaviorOnMxFailure;

    private PutEmailIdentityMailFromAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.mailFromDomain = builder.mailFromDomain;
        this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
    }

    public final String emailIdentity() {
        return this.emailIdentity;
    }

    public final String mailFromDomain() {
        return this.mailFromDomain;
    }

    public final BehaviorOnMxFailure behaviorOnMxFailure() {
        return BehaviorOnMxFailure.fromValue(this.behaviorOnMxFailure);
    }

    public final String behaviorOnMxFailureAsString() {
        return this.behaviorOnMxFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorOnMxFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityMailFromAttributesRequest)) {
            return false;
        }
        PutEmailIdentityMailFromAttributesRequest other = (PutEmailIdentityMailFromAttributesRequest)((Object)obj);
        return Objects.equals(this.emailIdentity(), other.emailIdentity()) && Objects.equals(this.mailFromDomain(), other.mailFromDomain()) && Objects.equals(this.behaviorOnMxFailureAsString(), other.behaviorOnMxFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutEmailIdentityMailFromAttributesRequest").add("EmailIdentity", (Object)this.emailIdentity()).add("MailFromDomain", (Object)this.mailFromDomain()).add("BehaviorOnMxFailure", (Object)this.behaviorOnMxFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailIdentity": {
                return Optional.ofNullable(clazz.cast(this.emailIdentity()));
            }
            case "MailFromDomain": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomain()));
            }
            case "BehaviorOnMxFailure": {
                return Optional.ofNullable(clazz.cast(this.behaviorOnMxFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EmailIdentity", EMAIL_IDENTITY_FIELD);
        map.put("MailFromDomain", MAIL_FROM_DOMAIN_FIELD);
        map.put("BehaviorOnMxFailure", BEHAVIOR_ON_MX_FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityMailFromAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityMailFromAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String emailIdentity;
        private String mailFromDomain;
        private String behaviorOnMxFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityMailFromAttributesRequest model) {
            super(model);
            this.emailIdentity(model.emailIdentity);
            this.mailFromDomain(model.mailFromDomain);
            this.behaviorOnMxFailure(model.behaviorOnMxFailure);
        }

        public final String getEmailIdentity() {
            return this.emailIdentity;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final String getMailFromDomain() {
            return this.mailFromDomain;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final String getBehaviorOnMxFailure() {
            return this.behaviorOnMxFailure;
        }

        public final void setBehaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
        }

        @Override
        public final Builder behaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure) {
            this.behaviorOnMxFailure(behaviorOnMxFailure == null ? null : behaviorOnMxFailure.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityMailFromAttributesRequest build() {
            return new PutEmailIdentityMailFromAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEmailIdentityMailFromAttributesRequest> {
        public Builder emailIdentity(String var1);

        public Builder mailFromDomain(String var1);

        public Builder behaviorOnMxFailure(String var1);

        public Builder behaviorOnMxFailure(BehaviorOnMxFailure var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

