/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdentityType {
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    DOMAIN("DOMAIN"),
    MANAGED_DOMAIN("MANAGED_DOMAIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdentityType> VALUE_MAP;
    private final String value;

    private IdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityType> knownValues() {
        EnumSet<IdentityType> knownValues = EnumSet.allOf(IdentityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdentityType.class, IdentityType::toString);
    }
}

