/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Template implements SdkPojo, Serializable, ToCopyableBuilder<Template.Builder, Template> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(Template::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<String> TEMPLATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateData").getter(getter(Template::templateData)).setter(setter(Builder::templateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String templateArn;

    private final String templateData;

    private Template(BuilderImpl builder) {
        this.templateArn = builder.templateArn;
        this.templateData = builder.templateData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the template.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * An object that defines the values to use for message variables in the template. This object is a set of key-value
     * pairs. Each key defines a message variable in the template. The corresponding value defines the value to use for
     * that variable.
     * </p>
     * 
     * @return An object that defines the values to use for message variables in the template. This object is a set of
     *         key-value pairs. Each key defines a message variable in the template. The corresponding value defines the
     *         value to use for that variable.
     */
    public final String templateData() {
        return templateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateData(), other.templateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Template").add("TemplateArn", templateArn()).add("TemplateData", templateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "TemplateData":
            return Optional.ofNullable(clazz.cast(templateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Template> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the template.
         * </p>
         * 
         * @param templateArn
         *        The Amazon Resource Name (ARN) of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * An object that defines the values to use for message variables in the template. This object is a set of
         * key-value pairs. Each key defines a message variable in the template. The corresponding value defines the
         * value to use for that variable.
         * </p>
         * 
         * @param templateData
         *        An object that defines the values to use for message variables in the template. This object is a set
         *        of key-value pairs. Each key defines a message variable in the template. The corresponding value
         *        defines the value to use for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateData(String templateData);
    }

    static final class BuilderImpl implements Builder {
        private String templateArn;

        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            templateArn(model.templateArn);
            templateData(model.templateData);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        @Transient
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateData() {
            return templateData;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        @Transient
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        @Override
        public Template build() {
            return new Template(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
