/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the Deliverability dashboard subscription for a verified domain that you
 * use to send email and currently has an active Deliverability dashboard subscription. If a Deliverability dashboard
 * subscription is active for a domain, you gain access to reputation, inbox placement, and other metrics for the
 * domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainDeliverabilityTrackingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainDeliverabilityTrackingOption.Builder, DomainDeliverabilityTrackingOption> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DomainDeliverabilityTrackingOption::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Instant> SUBSCRIPTION_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubscriptionStartDate").getter(getter(DomainDeliverabilityTrackingOption::subscriptionStartDate))
            .setter(setter(Builder::subscriptionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStartDate").build())
            .build();

    private static final SdkField<InboxPlacementTrackingOption> INBOX_PLACEMENT_TRACKING_OPTION_FIELD = SdkField
            .<InboxPlacementTrackingOption> builder(MarshallingType.SDK_POJO)
            .memberName("InboxPlacementTrackingOption")
            .getter(getter(DomainDeliverabilityTrackingOption::inboxPlacementTrackingOption))
            .setter(setter(Builder::inboxPlacementTrackingOption))
            .constructor(InboxPlacementTrackingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxPlacementTrackingOption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            SUBSCRIPTION_START_DATE_FIELD, INBOX_PLACEMENT_TRACKING_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final Instant subscriptionStartDate;

    private final InboxPlacementTrackingOption inboxPlacementTrackingOption;

    private DomainDeliverabilityTrackingOption(BuilderImpl builder) {
        this.domain = builder.domain;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.inboxPlacementTrackingOption = builder.inboxPlacementTrackingOption;
    }

    /**
     * <p>
     * A verified domain that’s associated with your AWS account and currently has an active Deliverability dashboard
     * subscription.
     * </p>
     * 
     * @return A verified domain that’s associated with your AWS account and currently has an active Deliverability
     *         dashboard subscription.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The date, in Unix time format, when you enabled the Deliverability dashboard for the domain.
     * </p>
     * 
     * @return The date, in Unix time format, when you enabled the Deliverability dashboard for the domain.
     */
    public final Instant subscriptionStartDate() {
        return subscriptionStartDate;
    }

    /**
     * <p>
     * An object that contains information about the inbox placement data settings for the domain.
     * </p>
     * 
     * @return An object that contains information about the inbox placement data settings for the domain.
     */
    public final InboxPlacementTrackingOption inboxPlacementTrackingOption() {
        return inboxPlacementTrackingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(inboxPlacementTrackingOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDeliverabilityTrackingOption)) {
            return false;
        }
        DomainDeliverabilityTrackingOption other = (DomainDeliverabilityTrackingOption) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(subscriptionStartDate(), other.subscriptionStartDate())
                && Objects.equals(inboxPlacementTrackingOption(), other.inboxPlacementTrackingOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainDeliverabilityTrackingOption").add("Domain", domain())
                .add("SubscriptionStartDate", subscriptionStartDate())
                .add("InboxPlacementTrackingOption", inboxPlacementTrackingOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "SubscriptionStartDate":
            return Optional.ofNullable(clazz.cast(subscriptionStartDate()));
        case "InboxPlacementTrackingOption":
            return Optional.ofNullable(clazz.cast(inboxPlacementTrackingOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDeliverabilityTrackingOption, T> g) {
        return obj -> g.apply((DomainDeliverabilityTrackingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainDeliverabilityTrackingOption> {
        /**
         * <p>
         * A verified domain that’s associated with your AWS account and currently has an active Deliverability
         * dashboard subscription.
         * </p>
         * 
         * @param domain
         *        A verified domain that’s associated with your AWS account and currently has an active Deliverability
         *        dashboard subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The date, in Unix time format, when you enabled the Deliverability dashboard for the domain.
         * </p>
         * 
         * @param subscriptionStartDate
         *        The date, in Unix time format, when you enabled the Deliverability dashboard for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionStartDate(Instant subscriptionStartDate);

        /**
         * <p>
         * An object that contains information about the inbox placement data settings for the domain.
         * </p>
         * 
         * @param inboxPlacementTrackingOption
         *        An object that contains information about the inbox placement data settings for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxPlacementTrackingOption(InboxPlacementTrackingOption inboxPlacementTrackingOption);

        /**
         * <p>
         * An object that contains information about the inbox placement data settings for the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link InboxPlacementTrackingOption.Builder} avoiding
         * the need to create one manually via {@link InboxPlacementTrackingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link InboxPlacementTrackingOption.Builder#build()} is called
         * immediately and its result is passed to {@link #inboxPlacementTrackingOption(InboxPlacementTrackingOption)}.
         * 
         * @param inboxPlacementTrackingOption
         *        a consumer that will call methods on {@link InboxPlacementTrackingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboxPlacementTrackingOption(InboxPlacementTrackingOption)
         */
        default Builder inboxPlacementTrackingOption(Consumer<InboxPlacementTrackingOption.Builder> inboxPlacementTrackingOption) {
            return inboxPlacementTrackingOption(InboxPlacementTrackingOption.builder()
                    .applyMutation(inboxPlacementTrackingOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private Instant subscriptionStartDate;

        private InboxPlacementTrackingOption inboxPlacementTrackingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDeliverabilityTrackingOption model) {
            domain(model.domain);
            subscriptionStartDate(model.subscriptionStartDate);
            inboxPlacementTrackingOption(model.inboxPlacementTrackingOption);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Instant getSubscriptionStartDate() {
            return subscriptionStartDate;
        }

        public final void setSubscriptionStartDate(Instant subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        @Override
        @Transient
        public final Builder subscriptionStartDate(Instant subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final InboxPlacementTrackingOption.Builder getInboxPlacementTrackingOption() {
            return inboxPlacementTrackingOption != null ? inboxPlacementTrackingOption.toBuilder() : null;
        }

        public final void setInboxPlacementTrackingOption(InboxPlacementTrackingOption.BuilderImpl inboxPlacementTrackingOption) {
            this.inboxPlacementTrackingOption = inboxPlacementTrackingOption != null ? inboxPlacementTrackingOption.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder inboxPlacementTrackingOption(InboxPlacementTrackingOption inboxPlacementTrackingOption) {
            this.inboxPlacementTrackingOption = inboxPlacementTrackingOption;
            return this;
        }

        @Override
        public DomainDeliverabilityTrackingOption build() {
            return new DomainDeliverabilityTrackingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
