/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a blacklisting event that impacts one of the dedicated IP addresses that is
 * associated with your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlacklistEntry implements SdkPojo, Serializable, ToCopyableBuilder<BlacklistEntry.Builder, BlacklistEntry> {
    private static final SdkField<String> RBL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RblName").getter(getter(BlacklistEntry::rblName)).setter(setter(Builder::rblName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RblName").build()).build();

    private static final SdkField<Instant> LISTING_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ListingTime").getter(getter(BlacklistEntry::listingTime)).setter(setter(Builder::listingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListingTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(BlacklistEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RBL_NAME_FIELD,
            LISTING_TIME_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rblName;

    private final Instant listingTime;

    private final String description;

    private BlacklistEntry(BuilderImpl builder) {
        this.rblName = builder.rblName;
        this.listingTime = builder.listingTime;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the blacklist that the IP address appears on.
     * </p>
     * 
     * @return The name of the blacklist that the IP address appears on.
     */
    public final String rblName() {
        return rblName;
    }

    /**
     * <p>
     * The time when the blacklisting event occurred, shown in Unix time format.
     * </p>
     * 
     * @return The time when the blacklisting event occurred, shown in Unix time format.
     */
    public final Instant listingTime() {
        return listingTime;
    }

    /**
     * <p>
     * Additional information about the blacklisting event, as provided by the blacklist maintainer.
     * </p>
     * 
     * @return Additional information about the blacklisting event, as provided by the blacklist maintainer.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rblName());
        hashCode = 31 * hashCode + Objects.hashCode(listingTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlacklistEntry)) {
            return false;
        }
        BlacklistEntry other = (BlacklistEntry) obj;
        return Objects.equals(rblName(), other.rblName()) && Objects.equals(listingTime(), other.listingTime())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlacklistEntry").add("RblName", rblName()).add("ListingTime", listingTime())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RblName":
            return Optional.ofNullable(clazz.cast(rblName()));
        case "ListingTime":
            return Optional.ofNullable(clazz.cast(listingTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlacklistEntry, T> g) {
        return obj -> g.apply((BlacklistEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlacklistEntry> {
        /**
         * <p>
         * The name of the blacklist that the IP address appears on.
         * </p>
         * 
         * @param rblName
         *        The name of the blacklist that the IP address appears on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rblName(String rblName);

        /**
         * <p>
         * The time when the blacklisting event occurred, shown in Unix time format.
         * </p>
         * 
         * @param listingTime
         *        The time when the blacklisting event occurred, shown in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingTime(Instant listingTime);

        /**
         * <p>
         * Additional information about the blacklisting event, as provided by the blacklist maintainer.
         * </p>
         * 
         * @param description
         *        Additional information about the blacklisting event, as provided by the blacklist maintainer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String rblName;

        private Instant listingTime;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(BlacklistEntry model) {
            rblName(model.rblName);
            listingTime(model.listingTime);
            description(model.description);
        }

        public final String getRblName() {
            return rblName;
        }

        @Override
        public final Builder rblName(String rblName) {
            this.rblName = rblName;
            return this;
        }

        public final void setRblName(String rblName) {
            this.rblName = rblName;
        }

        public final Instant getListingTime() {
            return listingTime;
        }

        @Override
        public final Builder listingTime(Instant listingTime) {
            this.listingTime = listingTime;
            return this;
        }

        public final void setListingTime(Instant listingTime) {
            this.listingTime = listingTime;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public BlacklistEntry build() {
            return new BlacklistEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
