/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you predict how
 * your messages will be handled by various email providers around the world. When you perform a predictive inbox
 * placement test, you provide a sample message that contains the content that you plan to send to your customers.
 * Amazon Pinpoint then sends that message to special email addresses spread across several major email providers. After
 * about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to view
 * the results of the test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeliverabilityTestReportRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<CreateDeliverabilityTestReportRequest.Builder, CreateDeliverabilityTestReportRequest> {
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportName").getter(getter(CreateDeliverabilityTestReportRequest::reportName))
            .setter(setter(Builder::reportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()).build();

    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromEmailAddress").getter(getter(CreateDeliverabilityTestReportRequest::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.<EmailContent> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(CreateDeliverabilityTestReportRequest::content))
            .setter(setter(Builder::content)).constructor(EmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDeliverabilityTestReportRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_NAME_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, CONTENT_FIELD, TAGS_FIELD));

    private final String reportName;

    private final String fromEmailAddress;

    private final EmailContent content;

    private final List<Tag> tags;

    private CreateDeliverabilityTestReportRequest(BuilderImpl builder) {
        super(builder);
        this.reportName = builder.reportName;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.content = builder.content;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.
     * </p>
     * 
     * @return A unique name that helps you to identify the predictive inbox placement test when you retrieve the
     *         results.
     */
    public final String reportName() {
        return reportName;
    }

    /**
     * <p>
     * The email address that the predictive inbox placement test email was sent from.
     * </p>
     * 
     * @return The email address that the predictive inbox placement test email was sent from.
     */
    public final String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The HTML body of the message that you sent when you performed the predictive inbox placement test.
     * </p>
     * 
     * @return The HTML body of the message that you sent when you performed the predictive inbox placement test.
     */
    public final EmailContent content() {
        return content;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox
     * placement test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that define the tags (keys and values) that you want to associate with the predictive
     *         inbox placement test.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportName());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliverabilityTestReportRequest)) {
            return false;
        }
        CreateDeliverabilityTestReportRequest other = (CreateDeliverabilityTestReportRequest) obj;
        return Objects.equals(reportName(), other.reportName()) && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(content(), other.content()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeliverabilityTestReportRequest").add("ReportName", reportName())
                .add("FromEmailAddress", fromEmailAddress()).add("Content", content()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportName":
            return Optional.ofNullable(clazz.cast(reportName()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliverabilityTestReportRequest, T> g) {
        return obj -> g.apply((CreateDeliverabilityTestReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDeliverabilityTestReportRequest> {
        /**
         * <p>
         * A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.
         * </p>
         * 
         * @param reportName
         *        A unique name that helps you to identify the predictive inbox placement test when you retrieve the
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportName(String reportName);

        /**
         * <p>
         * The email address that the predictive inbox placement test email was sent from.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address that the predictive inbox placement test email was sent from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * The HTML body of the message that you sent when you performed the predictive inbox placement test.
         * </p>
         * 
         * @param content
         *        The HTML body of the message that you sent when you performed the predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(EmailContent content);

        /**
         * <p>
         * The HTML body of the message that you sent when you performed the predictive inbox placement test.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailContent.Builder} avoiding the need to
         * create one manually via {@link EmailContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(EmailContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link EmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(EmailContent)
         */
        default Builder content(Consumer<EmailContent.Builder> content) {
            return content(EmailContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that you want to associate with the predictive
         * inbox placement test.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that you want to associate with the
         *        predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that you want to associate with the predictive
         * inbox placement test.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that you want to associate with the
         *        predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that you want to associate with the predictive
         * inbox placement test.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String reportName;

        private String fromEmailAddress;

        private EmailContent content;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliverabilityTestReportRequest model) {
            super(model);
            reportName(model.reportName);
            fromEmailAddress(model.fromEmailAddress);
            content(model.content);
            tags(model.tags);
        }

        public final String getReportName() {
            return reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        public final EmailContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliverabilityTestReportRequest build() {
            return new CreateDeliverabilityTestReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
