/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that shows the status of the Deliverability dashboard for your Amazon Pinpoint account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeliverabilityDashboardOptionsResponse extends PinpointEmailResponse implements
        ToCopyableBuilder<GetDeliverabilityDashboardOptionsResponse.Builder, GetDeliverabilityDashboardOptionsResponse> {
    private static final SdkField<Boolean> DASHBOARD_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DashboardEnabled").getter(getter(GetDeliverabilityDashboardOptionsResponse::dashboardEnabled))
            .setter(setter(Builder::dashboardEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardEnabled").build()).build();

    private static final SdkField<Instant> SUBSCRIPTION_EXPIRY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubscriptionExpiryDate")
            .getter(getter(GetDeliverabilityDashboardOptionsResponse::subscriptionExpiryDate))
            .setter(setter(Builder::subscriptionExpiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionExpiryDate").build())
            .build();

    private static final SdkField<String> ACCOUNT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountStatus").getter(getter(GetDeliverabilityDashboardOptionsResponse::accountStatusAsString))
            .setter(setter(Builder::accountStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountStatus").build()).build();

    private static final SdkField<List<DomainDeliverabilityTrackingOption>> ACTIVE_SUBSCRIBED_DOMAINS_FIELD = SdkField
            .<List<DomainDeliverabilityTrackingOption>> builder(MarshallingType.LIST)
            .memberName("ActiveSubscribedDomains")
            .getter(getter(GetDeliverabilityDashboardOptionsResponse::activeSubscribedDomains))
            .setter(setter(Builder::activeSubscribedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSubscribedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainDeliverabilityTrackingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainDeliverabilityTrackingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DomainDeliverabilityTrackingOption>> PENDING_EXPIRATION_SUBSCRIBED_DOMAINS_FIELD = SdkField
            .<List<DomainDeliverabilityTrackingOption>> builder(MarshallingType.LIST)
            .memberName("PendingExpirationSubscribedDomains")
            .getter(getter(GetDeliverabilityDashboardOptionsResponse::pendingExpirationSubscribedDomains))
            .setter(setter(Builder::pendingExpirationSubscribedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingExpirationSubscribedDomains")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainDeliverabilityTrackingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainDeliverabilityTrackingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ENABLED_FIELD,
            SUBSCRIPTION_EXPIRY_DATE_FIELD, ACCOUNT_STATUS_FIELD, ACTIVE_SUBSCRIBED_DOMAINS_FIELD,
            PENDING_EXPIRATION_SUBSCRIBED_DOMAINS_FIELD));

    private final Boolean dashboardEnabled;

    private final Instant subscriptionExpiryDate;

    private final String accountStatus;

    private final List<DomainDeliverabilityTrackingOption> activeSubscribedDomains;

    private final List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains;

    private GetDeliverabilityDashboardOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardEnabled = builder.dashboardEnabled;
        this.subscriptionExpiryDate = builder.subscriptionExpiryDate;
        this.accountStatus = builder.accountStatus;
        this.activeSubscribedDomains = builder.activeSubscribedDomains;
        this.pendingExpirationSubscribedDomains = builder.pendingExpirationSubscribedDomains;
    }

    /**
     * <p>
     * Specifies whether the Deliverability dashboard is enabled for your Amazon Pinpoint account. If this value is
     * <code>true</code>, the dashboard is enabled.
     * </p>
     * 
     * @return Specifies whether the Deliverability dashboard is enabled for your Amazon Pinpoint account. If this value
     *         is <code>true</code>, the dashboard is enabled.
     */
    public Boolean dashboardEnabled() {
        return dashboardEnabled;
    }

    /**
     * <p>
     * The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to
     * expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null
     * if you have an active subscription that isn’t due to expire at the end of the month.
     * </p>
     * 
     * @return The date, in Unix time format, when your current subscription to the Deliverability dashboard is
     *         scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar
     *         month. This value is null if you have an active subscription that isn’t due to expire at the end of the
     *         month.
     */
    public Instant subscriptionExpiryDate() {
        return subscriptionExpiryDate;
    }

    /**
     * <p>
     * The current status of your Deliverability dashboard subscription. If this value is
     * <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar
     * month.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountStatus}
     * will return {@link DeliverabilityDashboardAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #accountStatusAsString}.
     * </p>
     * 
     * @return The current status of your Deliverability dashboard subscription. If this value is
     *         <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current
     *         calendar month.
     * @see DeliverabilityDashboardAccountStatus
     */
    public DeliverabilityDashboardAccountStatus accountStatus() {
        return DeliverabilityDashboardAccountStatus.fromValue(accountStatus);
    }

    /**
     * <p>
     * The current status of your Deliverability dashboard subscription. If this value is
     * <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar
     * month.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountStatus}
     * will return {@link DeliverabilityDashboardAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #accountStatusAsString}.
     * </p>
     * 
     * @return The current status of your Deliverability dashboard subscription. If this value is
     *         <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current
     *         calendar month.
     * @see DeliverabilityDashboardAccountStatus
     */
    public String accountStatusAsString() {
        return accountStatus;
    }

    /**
     * Returns true if the ActiveSubscribedDomains property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasActiveSubscribedDomains() {
        return activeSubscribedDomains != null && !(activeSubscribedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each verified domain that you use to send email and currently has an active
     * Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActiveSubscribedDomains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each verified domain that you use to send email and currently has an active
     *         Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar
     *         month.
     */
    public List<DomainDeliverabilityTrackingOption> activeSubscribedDomains() {
        return activeSubscribedDomains;
    }

    /**
     * Returns true if the PendingExpirationSubscribedDomains property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasPendingExpirationSubscribedDomains() {
        return pendingExpirationSubscribedDomains != null
                && !(pendingExpirationSubscribedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each verified domain that you use to send email and currently has an active
     * Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPendingExpirationSubscribedDomains()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each verified domain that you use to send email and currently has an active
     *         Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar
     *         month.
     */
    public List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains() {
        return pendingExpirationSubscribedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(accountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveSubscribedDomains() ? activeSubscribedDomains() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPendingExpirationSubscribedDomains() ? pendingExpirationSubscribedDomains() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliverabilityDashboardOptionsResponse)) {
            return false;
        }
        GetDeliverabilityDashboardOptionsResponse other = (GetDeliverabilityDashboardOptionsResponse) obj;
        return Objects.equals(dashboardEnabled(), other.dashboardEnabled())
                && Objects.equals(subscriptionExpiryDate(), other.subscriptionExpiryDate())
                && Objects.equals(accountStatusAsString(), other.accountStatusAsString())
                && hasActiveSubscribedDomains() == other.hasActiveSubscribedDomains()
                && Objects.equals(activeSubscribedDomains(), other.activeSubscribedDomains())
                && hasPendingExpirationSubscribedDomains() == other.hasPendingExpirationSubscribedDomains()
                && Objects.equals(pendingExpirationSubscribedDomains(), other.pendingExpirationSubscribedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("GetDeliverabilityDashboardOptionsResponse")
                .add("DashboardEnabled", dashboardEnabled())
                .add("SubscriptionExpiryDate", subscriptionExpiryDate())
                .add("AccountStatus", accountStatusAsString())
                .add("ActiveSubscribedDomains", hasActiveSubscribedDomains() ? activeSubscribedDomains() : null)
                .add("PendingExpirationSubscribedDomains",
                        hasPendingExpirationSubscribedDomains() ? pendingExpirationSubscribedDomains() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardEnabled":
            return Optional.ofNullable(clazz.cast(dashboardEnabled()));
        case "SubscriptionExpiryDate":
            return Optional.ofNullable(clazz.cast(subscriptionExpiryDate()));
        case "AccountStatus":
            return Optional.ofNullable(clazz.cast(accountStatusAsString()));
        case "ActiveSubscribedDomains":
            return Optional.ofNullable(clazz.cast(activeSubscribedDomains()));
        case "PendingExpirationSubscribedDomains":
            return Optional.ofNullable(clazz.cast(pendingExpirationSubscribedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeliverabilityDashboardOptionsResponse, T> g) {
        return obj -> g.apply((GetDeliverabilityDashboardOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeliverabilityDashboardOptionsResponse> {
        /**
         * <p>
         * Specifies whether the Deliverability dashboard is enabled for your Amazon Pinpoint account. If this value is
         * <code>true</code>, the dashboard is enabled.
         * </p>
         * 
         * @param dashboardEnabled
         *        Specifies whether the Deliverability dashboard is enabled for your Amazon Pinpoint account. If this
         *        value is <code>true</code>, the dashboard is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEnabled(Boolean dashboardEnabled);

        /**
         * <p>
         * The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to
         * expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is
         * null if you have an active subscription that isn’t due to expire at the end of the month.
         * </p>
         * 
         * @param subscriptionExpiryDate
         *        The date, in Unix time format, when your current subscription to the Deliverability dashboard is
         *        scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar
         *        month. This value is null if you have an active subscription that isn’t due to expire at the end of
         *        the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionExpiryDate(Instant subscriptionExpiryDate);

        /**
         * <p>
         * The current status of your Deliverability dashboard subscription. If this value is
         * <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar
         * month.
         * </p>
         * 
         * @param accountStatus
         *        The current status of your Deliverability dashboard subscription. If this value is
         *        <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current
         *        calendar month.
         * @see DeliverabilityDashboardAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityDashboardAccountStatus
         */
        Builder accountStatus(String accountStatus);

        /**
         * <p>
         * The current status of your Deliverability dashboard subscription. If this value is
         * <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar
         * month.
         * </p>
         * 
         * @param accountStatus
         *        The current status of your Deliverability dashboard subscription. If this value is
         *        <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current
         *        calendar month.
         * @see DeliverabilityDashboardAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityDashboardAccountStatus
         */
        Builder accountStatus(DeliverabilityDashboardAccountStatus accountStatus);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar
         * month.
         * </p>
         * 
         * @param activeSubscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and currently has an
         *        active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current
         *        calendar month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> activeSubscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar
         * month.
         * </p>
         * 
         * @param activeSubscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and currently has an
         *        active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current
         *        calendar month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeSubscribedDomains(DomainDeliverabilityTrackingOption... activeSubscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar
         * month.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DomainDeliverabilityTrackingOption>.Builder} avoiding the need to create one manually via {@link List
         * <DomainDeliverabilityTrackingOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainDeliverabilityTrackingOption>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #activeSubscribedDomains(List<DomainDeliverabilityTrackingOption>)}.
         * 
         * @param activeSubscribedDomains
         *        a consumer that will call methods on {@link List<DomainDeliverabilityTrackingOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeSubscribedDomains(List<DomainDeliverabilityTrackingOption>)
         */
        Builder activeSubscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder>... activeSubscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
         * </p>
         * 
         * @param pendingExpirationSubscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and currently has an
         *        active Deliverability dashboard subscription that's scheduled to expire at the end of the current
         *        calendar month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingExpirationSubscribedDomains(
                Collection<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
         * </p>
         * 
         * @param pendingExpirationSubscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and currently has an
         *        active Deliverability dashboard subscription that's scheduled to expire at the end of the current
         *        calendar month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingExpirationSubscribedDomains(DomainDeliverabilityTrackingOption... pendingExpirationSubscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and currently has an active
         * Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DomainDeliverabilityTrackingOption>.Builder} avoiding the need to create one manually via {@link List
         * <DomainDeliverabilityTrackingOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainDeliverabilityTrackingOption>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #pendingExpirationSubscribedDomains(List<DomainDeliverabilityTrackingOption>)}.
         * 
         * @param pendingExpirationSubscribedDomains
         *        a consumer that will call methods on {@link List<DomainDeliverabilityTrackingOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingExpirationSubscribedDomains(List<DomainDeliverabilityTrackingOption>)
         */
        Builder pendingExpirationSubscribedDomains(
                Consumer<DomainDeliverabilityTrackingOption.Builder>... pendingExpirationSubscribedDomains);
    }

    static final class BuilderImpl extends PinpointEmailResponse.BuilderImpl implements Builder {
        private Boolean dashboardEnabled;

        private Instant subscriptionExpiryDate;

        private String accountStatus;

        private List<DomainDeliverabilityTrackingOption> activeSubscribedDomains = DefaultSdkAutoConstructList.getInstance();

        private List<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliverabilityDashboardOptionsResponse model) {
            super(model);
            dashboardEnabled(model.dashboardEnabled);
            subscriptionExpiryDate(model.subscriptionExpiryDate);
            accountStatus(model.accountStatus);
            activeSubscribedDomains(model.activeSubscribedDomains);
            pendingExpirationSubscribedDomains(model.pendingExpirationSubscribedDomains);
        }

        public final Boolean getDashboardEnabled() {
            return dashboardEnabled;
        }

        @Override
        public final Builder dashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
            return this;
        }

        public final void setDashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
        }

        public final Instant getSubscriptionExpiryDate() {
            return subscriptionExpiryDate;
        }

        @Override
        public final Builder subscriptionExpiryDate(Instant subscriptionExpiryDate) {
            this.subscriptionExpiryDate = subscriptionExpiryDate;
            return this;
        }

        public final void setSubscriptionExpiryDate(Instant subscriptionExpiryDate) {
            this.subscriptionExpiryDate = subscriptionExpiryDate;
        }

        public final String getAccountStatus() {
            return accountStatus;
        }

        @Override
        public final Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        @Override
        public final Builder accountStatus(DeliverabilityDashboardAccountStatus accountStatus) {
            this.accountStatus(accountStatus == null ? null : accountStatus.toString());
            return this;
        }

        public final void setAccountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
        }

        public final Collection<DomainDeliverabilityTrackingOption.Builder> getActiveSubscribedDomains() {
            if (activeSubscribedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return activeSubscribedDomains != null ? activeSubscribedDomains.stream()
                    .map(DomainDeliverabilityTrackingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activeSubscribedDomains(Collection<DomainDeliverabilityTrackingOption> activeSubscribedDomains) {
            this.activeSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copy(activeSubscribedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeSubscribedDomains(DomainDeliverabilityTrackingOption... activeSubscribedDomains) {
            activeSubscribedDomains(Arrays.asList(activeSubscribedDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeSubscribedDomains(
                Consumer<DomainDeliverabilityTrackingOption.Builder>... activeSubscribedDomains) {
            activeSubscribedDomains(Stream.of(activeSubscribedDomains)
                    .map(c -> DomainDeliverabilityTrackingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActiveSubscribedDomains(
                Collection<DomainDeliverabilityTrackingOption.BuilderImpl> activeSubscribedDomains) {
            this.activeSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copyFromBuilder(activeSubscribedDomains);
        }

        public final Collection<DomainDeliverabilityTrackingOption.Builder> getPendingExpirationSubscribedDomains() {
            if (pendingExpirationSubscribedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return pendingExpirationSubscribedDomains != null ? pendingExpirationSubscribedDomains.stream()
                    .map(DomainDeliverabilityTrackingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingExpirationSubscribedDomains(
                Collection<DomainDeliverabilityTrackingOption> pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier
                    .copy(pendingExpirationSubscribedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingExpirationSubscribedDomains(
                DomainDeliverabilityTrackingOption... pendingExpirationSubscribedDomains) {
            pendingExpirationSubscribedDomains(Arrays.asList(pendingExpirationSubscribedDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingExpirationSubscribedDomains(
                Consumer<DomainDeliverabilityTrackingOption.Builder>... pendingExpirationSubscribedDomains) {
            pendingExpirationSubscribedDomains(Stream.of(pendingExpirationSubscribedDomains)
                    .map(c -> DomainDeliverabilityTrackingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPendingExpirationSubscribedDomains(
                Collection<DomainDeliverabilityTrackingOption.BuilderImpl> pendingExpirationSubscribedDomains) {
            this.pendingExpirationSubscribedDomains = DomainDeliverabilityTrackingOptionsCopier
                    .copyFromBuilder(pendingExpirationSubscribedDomains);
        }

        @Override
        public GetDeliverabilityDashboardOptionsResponse build() {
            return new GetDeliverabilityDashboardOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
