/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.Destination;
import software.amazon.awssdk.services.pinpointemail.model.EmailAddressListCopier;
import software.amazon.awssdk.services.pinpointemail.model.EmailContent;
import software.amazon.awssdk.services.pinpointemail.model.MessageTag;
import software.amazon.awssdk.services.pinpointemail.model.MessageTagListCopier;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendEmailRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, SendEmailRequest> {
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendEmailRequest.getter(SendEmailRequest::fromEmailAddress)).setter(SendEmailRequest.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendEmailRequest.getter(SendEmailRequest::destination)).setter(SendEmailRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendEmailRequest.getter(SendEmailRequest::replyToAddresses)).setter(SendEmailRequest.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendEmailRequest.getter(SendEmailRequest::feedbackForwardingEmailAddress)).setter(SendEmailRequest.setter(Builder::feedbackForwardingEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddress").build()}).build();
    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendEmailRequest.getter(SendEmailRequest::content)).setter(SendEmailRequest.setter(Builder::content)).constructor(EmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<List<MessageTag>> EMAIL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendEmailRequest.getter(SendEmailRequest::emailTags)).setter(SendEmailRequest.setter(Builder::emailTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendEmailRequest.getter(SendEmailRequest::configurationSetName)).setter(SendEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD, DESTINATION_FIELD, REPLY_TO_ADDRESSES_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD, CONTENT_FIELD, EMAIL_TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD));
    private final String fromEmailAddress;
    private final Destination destination;
    private final List<String> replyToAddresses;
    private final String feedbackForwardingEmailAddress;
    private final EmailContent content;
    private final List<MessageTag> emailTags;
    private final String configurationSetName;

    private SendEmailRequest(BuilderImpl builder) {
        super(builder);
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destination = builder.destination;
        this.replyToAddresses = builder.replyToAddresses;
        this.feedbackForwardingEmailAddress = builder.feedbackForwardingEmailAddress;
        this.content = builder.content;
        this.emailTags = builder.emailTags;
        this.configurationSetName = builder.configurationSetName;
    }

    public String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public Destination destination() {
        return this.destination;
    }

    public List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public String feedbackForwardingEmailAddress() {
        return this.feedbackForwardingEmailAddress;
    }

    public EmailContent content() {
        return this.content;
    }

    public List<MessageTag> emailTags() {
        return this.emailTags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.replyToAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)((Object)obj);
        return Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.feedbackForwardingEmailAddress(), other.feedbackForwardingEmailAddress()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.emailTags(), other.emailTags()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public String toString() {
        return ToString.builder((String)"SendEmailRequest").add("FromEmailAddress", (Object)this.fromEmailAddress()).add("Destination", (Object)this.destination()).add("ReplyToAddresses", this.replyToAddresses()).add("FeedbackForwardingEmailAddress", (Object)this.feedbackForwardingEmailAddress()).add("Content", (Object)this.content()).add("EmailTags", this.emailTags()).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "FeedbackForwardingEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingEmailAddress()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "EmailTags": {
                return Optional.ofNullable(clazz.cast(this.emailTags()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendEmailRequest, T> g) {
        return obj -> g.apply((SendEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String fromEmailAddress;
        private Destination destination;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private String feedbackForwardingEmailAddress;
        private EmailContent content;
        private List<MessageTag> emailTags = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendEmailRequest model) {
            super(model);
            this.fromEmailAddress(model.fromEmailAddress);
            this.destination(model.destination);
            this.replyToAddresses(model.replyToAddresses);
            this.feedbackForwardingEmailAddress(model.feedbackForwardingEmailAddress);
            this.content(model.content);
            this.emailTags(model.emailTags);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<String> getReplyToAddresses() {
            return this.replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
        }

        public final String getFeedbackForwardingEmailAddress() {
            return this.feedbackForwardingEmailAddress;
        }

        @Override
        public final Builder feedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
            return this;
        }

        public final void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
        }

        public final EmailContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final Collection<MessageTag.Builder> getEmailTags() {
            return this.emailTags != null ? (Collection)this.emailTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder emailTags(Collection<MessageTag> emailTags) {
            this.emailTags = MessageTagListCopier.copy(emailTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(MessageTag ... emailTags) {
            this.emailTags(Arrays.asList(emailTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(Consumer<MessageTag.Builder> ... emailTags) {
            this.emailTags(Stream.of(emailTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEmailTags(Collection<MessageTag.BuilderImpl> emailTags) {
            this.emailTags = MessageTagListCopier.copyFromBuilder(emailTags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEmailRequest build() {
            return new SendEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendEmailRequest> {
        public Builder fromEmailAddress(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder feedbackForwardingEmailAddress(String var1);

        public Builder content(EmailContent var1);

        default public Builder content(Consumer<EmailContent.Builder> content) {
            return this.content((EmailContent)((EmailContent.Builder)EmailContent.builder().applyMutation(content)).build());
        }

        public Builder emailTags(Collection<MessageTag> var1);

        public Builder emailTags(MessageTag ... var1);

        public Builder emailTags(Consumer<MessageTag.Builder> ... var1);

        public Builder configurationSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

