/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.EmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEmailTemplateRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, CreateEmailTemplateRequest> {
    private static final SdkField<EmailTemplateRequest> EMAIL_TEMPLATE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateEmailTemplateRequest.getter(CreateEmailTemplateRequest::emailTemplateRequest)).setter(CreateEmailTemplateRequest.setter(Builder::emailTemplateRequest)).constructor(EmailTemplateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTemplateRequest").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEmailTemplateRequest.getter(CreateEmailTemplateRequest::templateName)).setter(CreateEmailTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_TEMPLATE_REQUEST_FIELD, TEMPLATE_NAME_FIELD));
    private final EmailTemplateRequest emailTemplateRequest;
    private final String templateName;

    private CreateEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.emailTemplateRequest = builder.emailTemplateRequest;
        this.templateName = builder.templateName;
    }

    public EmailTemplateRequest emailTemplateRequest() {
        return this.emailTemplateRequest;
    }

    public String templateName() {
        return this.templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.emailTemplateRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEmailTemplateRequest)) {
            return false;
        }
        CreateEmailTemplateRequest other = (CreateEmailTemplateRequest)((Object)obj);
        return Objects.equals(this.emailTemplateRequest(), other.emailTemplateRequest()) && Objects.equals(this.templateName(), other.templateName());
    }

    public String toString() {
        return ToString.builder((String)"CreateEmailTemplateRequest").add("EmailTemplateRequest", (Object)this.emailTemplateRequest()).add("TemplateName", (Object)this.templateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailTemplateRequest": {
                return Optional.ofNullable(clazz.cast(this.emailTemplateRequest()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEmailTemplateRequest, T> g) {
        return obj -> g.apply((CreateEmailTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private EmailTemplateRequest emailTemplateRequest;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEmailTemplateRequest model) {
            super(model);
            this.emailTemplateRequest(model.emailTemplateRequest);
            this.templateName(model.templateName);
        }

        public final EmailTemplateRequest.Builder getEmailTemplateRequest() {
            return this.emailTemplateRequest != null ? this.emailTemplateRequest.toBuilder() : null;
        }

        @Override
        public final Builder emailTemplateRequest(EmailTemplateRequest emailTemplateRequest) {
            this.emailTemplateRequest = emailTemplateRequest;
            return this;
        }

        public final void setEmailTemplateRequest(EmailTemplateRequest.BuilderImpl emailTemplateRequest) {
            this.emailTemplateRequest = emailTemplateRequest != null ? emailTemplateRequest.build() : null;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEmailTemplateRequest build() {
            return new CreateEmailTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEmailTemplateRequest> {
        public Builder emailTemplateRequest(EmailTemplateRequest var1);

        default public Builder emailTemplateRequest(Consumer<EmailTemplateRequest.Builder> emailTemplateRequest) {
            return this.emailTemplateRequest((EmailTemplateRequest)((EmailTemplateRequest.Builder)EmailTemplateRequest.builder().applyMutation(emailTemplateRequest)).build());
        }

        public Builder templateName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

