/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a single value and metadata about that value as part of an array of query results for a standard metric that
 * applies to an application or campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultRowValue implements SdkPojo, Serializable, ToCopyableBuilder<ResultRowValue.Builder, ResultRowValue> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResultRowValue::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResultRowValue::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResultRowValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, TYPE_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String type;

    private final String value;

    private ResultRowValue(BuilderImpl builder) {
        this.key = builder.key;
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the field that Amazon Pinpoint uses to store the value specified by the Value property.
     * </p>
     * 
     * @return The name of the field that Amazon Pinpoint uses to store the value specified by the Value property.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The data type of the value specified by the Value property.
     * </p>
     * 
     * @return <p>
     *         The data type of the value specified by the Value property.
     *         </p>
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * In a Values object, the value for the metric that the query retrieved data for. In a GroupedBys object, the value
     * for the field that was used to group data in a result set that contains multiple results (Values objects).
     * </p>
     * 
     * @return In a Values object, the value for the metric that the query retrieved data for. In a GroupedBys object,
     *         the value for the field that was used to group data in a result set that contains multiple results
     *         (Values objects).
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultRowValue)) {
            return false;
        }
        ResultRowValue other = (ResultRowValue) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(type(), other.type())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultRowValue").add("Key", key()).add("Type", type()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultRowValue, T> g) {
        return obj -> g.apply((ResultRowValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultRowValue> {
        /**
         * <p>
         * The name of the field that Amazon Pinpoint uses to store the value specified by the Value property.
         * </p>
         * 
         * @param key
         *        The name of the field that Amazon Pinpoint uses to store the value specified by the Value property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The data type of the value specified by the Value property.
         * </p>
         * 
         * @param type
         *        <p>
         *        The data type of the value specified by the Value property.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * In a Values object, the value for the metric that the query retrieved data for. In a GroupedBys object, the
         * value for the field that was used to group data in a result set that contains multiple results (Values
         * objects).
         * </p>
         * 
         * @param value
         *        In a Values object, the value for the metric that the query retrieved data for. In a GroupedBys
         *        object, the value for the field that was used to group data in a result set that contains multiple
         *        results (Values objects).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String type;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultRowValue model) {
            key(model.key);
            type(model.type);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ResultRowValue build() {
            return new ResultRowValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
