/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies metric-based criteria for including or excluding endpoints from a segment. These criteria derive from
 * custom metrics that you define for endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDimension implements SdkPojo, Serializable, ToCopyableBuilder<MetricDimension.Builder, MetricDimension> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricDimension::comparisonOperator)).setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricDimension::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparisonOperator;

    private final Double value;

    private MetricDimension(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN,
     * GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
     * </p>
     * 
     * @return The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN,
     *         GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
     */
    public String comparisonOperator() {
        return comparisonOperator;
    }

    /**
     * <p>
     * The value to compare.
     * </p>
     * 
     * @return The value to compare.
     */
    public Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperator());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDimension)) {
            return false;
        }
        MetricDimension other = (MetricDimension) obj;
        return Objects.equals(comparisonOperator(), other.comparisonOperator()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricDimension").add("ComparisonOperator", comparisonOperator()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperator()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDimension, T> g) {
        return obj -> g.apply((MetricDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDimension> {
        /**
         * <p>
         * The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN,
         * GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
         * </p>
         * 
         * @param comparisonOperator
         *        The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN,
         *        GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The value to compare.
         * </p>
         * 
         * @param value
         *        The value to compare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOperator;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDimension model) {
            comparisonOperator(model.comparisonOperator);
            value(model.value);
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getValue() {
            return value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public MetricDimension build() {
            return new MetricDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
