/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the results of a request to create or update an endpoint that's associated with an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemResponse implements SdkPojo, Serializable, ToCopyableBuilder<ItemResponse.Builder, ItemResponse> {
    private static final SdkField<EndpointItemResponse> ENDPOINT_ITEM_RESPONSE_FIELD = SdkField
            .<EndpointItemResponse> builder(MarshallingType.SDK_POJO).getter(getter(ItemResponse::endpointItemResponse))
            .setter(setter(Builder::endpointItemResponse)).constructor(EndpointItemResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointItemResponse").build())
            .build();

    private static final SdkField<Map<String, EventItemResponse>> EVENTS_ITEM_RESPONSE_FIELD = SdkField
            .<Map<String, EventItemResponse>> builder(MarshallingType.MAP)
            .getter(getter(ItemResponse::eventsItemResponse))
            .setter(setter(Builder::eventsItemResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsItemResponse").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EventItemResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventItemResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ITEM_RESPONSE_FIELD,
            EVENTS_ITEM_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EndpointItemResponse endpointItemResponse;

    private final Map<String, EventItemResponse> eventsItemResponse;

    private ItemResponse(BuilderImpl builder) {
        this.endpointItemResponse = builder.endpointItemResponse;
        this.eventsItemResponse = builder.eventsItemResponse;
    }

    /**
     * <p>
     * The response that was received after the endpoint data was accepted.
     * </p>
     * 
     * @return The response that was received after the endpoint data was accepted.
     */
    public EndpointItemResponse endpointItemResponse() {
        return endpointItemResponse;
    }

    /**
     * <p>
     * A multipart response object that contains a key and a value for each event in the request. In each object, the
     * event ID is the key and an EventItemResponse object is the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A multipart response object that contains a key and a value for each event in the request. In each
     *         object, the event ID is the key and an EventItemResponse object is the value.
     */
    public Map<String, EventItemResponse> eventsItemResponse() {
        return eventsItemResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointItemResponse());
        hashCode = 31 * hashCode + Objects.hashCode(eventsItemResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemResponse)) {
            return false;
        }
        ItemResponse other = (ItemResponse) obj;
        return Objects.equals(endpointItemResponse(), other.endpointItemResponse())
                && Objects.equals(eventsItemResponse(), other.eventsItemResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ItemResponse").add("EndpointItemResponse", endpointItemResponse())
                .add("EventsItemResponse", eventsItemResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointItemResponse":
            return Optional.ofNullable(clazz.cast(endpointItemResponse()));
        case "EventsItemResponse":
            return Optional.ofNullable(clazz.cast(eventsItemResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ItemResponse, T> g) {
        return obj -> g.apply((ItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemResponse> {
        /**
         * <p>
         * The response that was received after the endpoint data was accepted.
         * </p>
         * 
         * @param endpointItemResponse
         *        The response that was received after the endpoint data was accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointItemResponse(EndpointItemResponse endpointItemResponse);

        /**
         * <p>
         * The response that was received after the endpoint data was accepted.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointItemResponse.Builder} avoiding the need
         * to create one manually via {@link EndpointItemResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointItemResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointItemResponse(EndpointItemResponse)}.
         * 
         * @param endpointItemResponse
         *        a consumer that will call methods on {@link EndpointItemResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointItemResponse(EndpointItemResponse)
         */
        default Builder endpointItemResponse(Consumer<EndpointItemResponse.Builder> endpointItemResponse) {
            return endpointItemResponse(EndpointItemResponse.builder().applyMutation(endpointItemResponse).build());
        }

        /**
         * <p>
         * A multipart response object that contains a key and a value for each event in the request. In each object,
         * the event ID is the key and an EventItemResponse object is the value.
         * </p>
         * 
         * @param eventsItemResponse
         *        A multipart response object that contains a key and a value for each event in the request. In each
         *        object, the event ID is the key and an EventItemResponse object is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse);
    }

    static final class BuilderImpl implements Builder {
        private EndpointItemResponse endpointItemResponse;

        private Map<String, EventItemResponse> eventsItemResponse = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemResponse model) {
            endpointItemResponse(model.endpointItemResponse);
            eventsItemResponse(model.eventsItemResponse);
        }

        public final EndpointItemResponse.Builder getEndpointItemResponse() {
            return endpointItemResponse != null ? endpointItemResponse.toBuilder() : null;
        }

        @Override
        public final Builder endpointItemResponse(EndpointItemResponse endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse;
            return this;
        }

        public final void setEndpointItemResponse(EndpointItemResponse.BuilderImpl endpointItemResponse) {
            this.endpointItemResponse = endpointItemResponse != null ? endpointItemResponse.build() : null;
        }

        public final Map<String, EventItemResponse.Builder> getEventsItemResponse() {
            return eventsItemResponse != null ? CollectionUtils.mapValues(eventsItemResponse, EventItemResponse::toBuilder)
                    : null;
        }

        @Override
        public final Builder eventsItemResponse(Map<String, EventItemResponse> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copy(eventsItemResponse);
            return this;
        }

        public final void setEventsItemResponse(Map<String, EventItemResponse.BuilderImpl> eventsItemResponse) {
            this.eventsItemResponse = MapOfEventItemResponseCopier.copyFromBuilder(eventsItemResponse);
        }

        @Override
        public ItemResponse build() {
            return new ItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
