/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ADMChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ADMChannelRequest.Builder, ADMChannelRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ADMChannelRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ADMChannelRequest::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ADMChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String clientSecret;

    private final Boolean enabled;

    private ADMChannelRequest(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The Client ID that you received from Amazon to send messages by using ADM.
     * </p>
     * 
     * @return The Client ID that you received from Amazon to send messages by using ADM.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The Client Secret that you received from Amazon to send messages by using ADM.
     * </p>
     * 
     * @return The Client Secret that you received from Amazon to send messages by using ADM.
     */
    public String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * Specifies whether to enable the ADM channel for the application.
     * </p>
     * 
     * @return Specifies whether to enable the ADM channel for the application.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ADMChannelRequest)) {
            return false;
        }
        ADMChannelRequest other = (ADMChannelRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ADMChannelRequest").add("ClientId", clientId()).add("ClientSecret", clientSecret())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ADMChannelRequest, T> g) {
        return obj -> g.apply((ADMChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ADMChannelRequest> {
        /**
         * <p>
         * The Client ID that you received from Amazon to send messages by using ADM.
         * </p>
         * 
         * @param clientId
         *        The Client ID that you received from Amazon to send messages by using ADM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The Client Secret that you received from Amazon to send messages by using ADM.
         * </p>
         * 
         * @param clientSecret
         *        The Client Secret that you received from Amazon to send messages by using ADM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * Specifies whether to enable the ADM channel for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable the ADM channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ADMChannelRequest model) {
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            enabled(model.enabled);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public ADMChannelRequest build() {
            return new ADMChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
