/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Verify OTP Message Response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerificationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VerificationResponse.Builder, VerificationResponse> {
    private static final SdkField<Boolean> VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Valid")
            .getter(getter(VerificationResponse::valid)).setter(setter(Builder::valid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Valid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean valid;

    private VerificationResponse(BuilderImpl builder) {
        this.valid = builder.valid;
    }

    /**
     * <p>
     * Specifies whether the OTP is valid or not.
     * </p>
     * 
     * @return Specifies whether the OTP is valid or not.
     */
    public final Boolean valid() {
        return valid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationResponse)) {
            return false;
        }
        VerificationResponse other = (VerificationResponse) obj;
        return Objects.equals(valid(), other.valid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerificationResponse").add("Valid", valid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Valid":
            return Optional.ofNullable(clazz.cast(valid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Valid", VALID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerificationResponse, T> g) {
        return obj -> g.apply((VerificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerificationResponse> {
        /**
         * <p>
         * Specifies whether the OTP is valid or not.
         * </p>
         * 
         * @param valid
         *        Specifies whether the OTP is valid or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(Boolean valid);
    }

    static final class BuilderImpl implements Builder {
        private Boolean valid;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationResponse model) {
            valid(model.valid);
        }

        public final Boolean getValid() {
            return valid;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public VerificationResponse build() {
            return new VerificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
