/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVoiceChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<UpdateVoiceChannelResponse.Builder, UpdateVoiceChannelResponse> {
    private static final SdkField<VoiceChannelResponse> VOICE_CHANNEL_RESPONSE_FIELD = SdkField
            .<VoiceChannelResponse> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceChannelResponse")
            .getter(getter(UpdateVoiceChannelResponse::voiceChannelResponse))
            .setter(setter(Builder::voiceChannelResponse))
            .constructor(VoiceChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CHANNEL_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VoiceChannelResponse voiceChannelResponse;

    private UpdateVoiceChannelResponse(BuilderImpl builder) {
        super(builder);
        this.voiceChannelResponse = builder.voiceChannelResponse;
    }

    /**
     * Returns the value of the VoiceChannelResponse property for this object.
     * 
     * @return The value of the VoiceChannelResponse property for this object.
     */
    public final VoiceChannelResponse voiceChannelResponse() {
        return voiceChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceChannelResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceChannelResponse)) {
            return false;
        }
        UpdateVoiceChannelResponse other = (UpdateVoiceChannelResponse) obj;
        return Objects.equals(voiceChannelResponse(), other.voiceChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVoiceChannelResponse").add("VoiceChannelResponse", voiceChannelResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceChannelResponse":
            return Optional.ofNullable(clazz.cast(voiceChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceChannelResponse", VOICE_CHANNEL_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceChannelResponse, T> g) {
        return obj -> g.apply((UpdateVoiceChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVoiceChannelResponse> {
        /**
         * Sets the value of the VoiceChannelResponse property for this object.
         *
         * @param voiceChannelResponse
         *        The new value for the VoiceChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceChannelResponse(VoiceChannelResponse voiceChannelResponse);

        /**
         * Sets the value of the VoiceChannelResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VoiceChannelResponse.Builder} avoiding
         * the need to create one manually via {@link VoiceChannelResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceChannelResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceChannelResponse(VoiceChannelResponse)}.
         * 
         * @param voiceChannelResponse
         *        a consumer that will call methods on {@link VoiceChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceChannelResponse(VoiceChannelResponse)
         */
        default Builder voiceChannelResponse(Consumer<VoiceChannelResponse.Builder> voiceChannelResponse) {
            return voiceChannelResponse(VoiceChannelResponse.builder().applyMutation(voiceChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private VoiceChannelResponse voiceChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceChannelResponse model) {
            super(model);
            voiceChannelResponse(model.voiceChannelResponse);
        }

        public final VoiceChannelResponse.Builder getVoiceChannelResponse() {
            return voiceChannelResponse != null ? voiceChannelResponse.toBuilder() : null;
        }

        public final void setVoiceChannelResponse(VoiceChannelResponse.BuilderImpl voiceChannelResponse) {
            this.voiceChannelResponse = voiceChannelResponse != null ? voiceChannelResponse.build() : null;
        }

        @Override
        public final Builder voiceChannelResponse(VoiceChannelResponse voiceChannelResponse) {
            this.voiceChannelResponse = voiceChannelResponse;
            return this;
        }

        @Override
        public UpdateVoiceChannelResponse build() {
            return new UpdateVoiceChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
