/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendUsersMessagesResponse extends PinpointResponse implements
        ToCopyableBuilder<SendUsersMessagesResponse.Builder, SendUsersMessagesResponse> {
    private static final SdkField<SendUsersMessageResponse> SEND_USERS_MESSAGE_RESPONSE_FIELD = SdkField
            .<SendUsersMessageResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SendUsersMessageResponse")
            .getter(getter(SendUsersMessagesResponse::sendUsersMessageResponse))
            .setter(setter(Builder::sendUsersMessageResponse))
            .constructor(SendUsersMessageResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendUsersMessageResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SEND_USERS_MESSAGE_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SendUsersMessageResponse sendUsersMessageResponse;

    private SendUsersMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.sendUsersMessageResponse = builder.sendUsersMessageResponse;
    }

    /**
     * Returns the value of the SendUsersMessageResponse property for this object.
     * 
     * @return The value of the SendUsersMessageResponse property for this object.
     */
    public final SendUsersMessageResponse sendUsersMessageResponse() {
        return sendUsersMessageResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sendUsersMessageResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessagesResponse)) {
            return false;
        }
        SendUsersMessagesResponse other = (SendUsersMessagesResponse) obj;
        return Objects.equals(sendUsersMessageResponse(), other.sendUsersMessageResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendUsersMessagesResponse").add("SendUsersMessageResponse", sendUsersMessageResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendUsersMessageResponse":
            return Optional.ofNullable(clazz.cast(sendUsersMessageResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SendUsersMessageResponse", SEND_USERS_MESSAGE_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessagesResponse, T> g) {
        return obj -> g.apply((SendUsersMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendUsersMessagesResponse> {
        /**
         * Sets the value of the SendUsersMessageResponse property for this object.
         *
         * @param sendUsersMessageResponse
         *        The new value for the SendUsersMessageResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendUsersMessageResponse(SendUsersMessageResponse sendUsersMessageResponse);

        /**
         * Sets the value of the SendUsersMessageResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SendUsersMessageResponse.Builder}
         * avoiding the need to create one manually via {@link SendUsersMessageResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendUsersMessageResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #sendUsersMessageResponse(SendUsersMessageResponse)}.
         * 
         * @param sendUsersMessageResponse
         *        a consumer that will call methods on {@link SendUsersMessageResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendUsersMessageResponse(SendUsersMessageResponse)
         */
        default Builder sendUsersMessageResponse(Consumer<SendUsersMessageResponse.Builder> sendUsersMessageResponse) {
            return sendUsersMessageResponse(SendUsersMessageResponse.builder().applyMutation(sendUsersMessageResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private SendUsersMessageResponse sendUsersMessageResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessagesResponse model) {
            super(model);
            sendUsersMessageResponse(model.sendUsersMessageResponse);
        }

        public final SendUsersMessageResponse.Builder getSendUsersMessageResponse() {
            return sendUsersMessageResponse != null ? sendUsersMessageResponse.toBuilder() : null;
        }

        public final void setSendUsersMessageResponse(SendUsersMessageResponse.BuilderImpl sendUsersMessageResponse) {
            this.sendUsersMessageResponse = sendUsersMessageResponse != null ? sendUsersMessageResponse.build() : null;
        }

        @Override
        public final Builder sendUsersMessageResponse(SendUsersMessageResponse sendUsersMessageResponse) {
            this.sendUsersMessageResponse = sendUsersMessageResponse;
            return this;
        }

        @Override
        public SendUsersMessagesResponse build() {
            return new SendUsersMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
