/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Send OTP message request parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendOTPMessageRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SendOTPMessageRequestParameters.Builder, SendOTPMessageRequestParameters> {
    private static final SdkField<Integer> ALLOWED_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllowedAttempts").getter(getter(SendOTPMessageRequestParameters::allowedAttempts))
            .setter(setter(Builder::allowedAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAttempts").build()).build();

    private static final SdkField<String> BRAND_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandName").getter(getter(SendOTPMessageRequestParameters::brandName))
            .setter(setter(Builder::brandName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandName").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(SendOTPMessageRequestParameters::channel)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<Integer> CODE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CodeLength").getter(getter(SendOTPMessageRequestParameters::codeLength))
            .setter(setter(Builder::codeLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeLength").build()).build();

    private static final SdkField<String> DESTINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIdentity").getter(getter(SendOTPMessageRequestParameters::destinationIdentity))
            .setter(setter(Builder::destinationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIdentity").build())
            .build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(SendOTPMessageRequestParameters::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SendOTPMessageRequestParameters::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(SendOTPMessageRequestParameters::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceId").getter(getter(SendOTPMessageRequestParameters::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(SendOTPMessageRequestParameters::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<Integer> VALIDITY_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidityPeriod").getter(getter(SendOTPMessageRequestParameters::validityPeriod))
            .setter(setter(Builder::validityPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ATTEMPTS_FIELD,
            BRAND_NAME_FIELD, CHANNEL_FIELD, CODE_LENGTH_FIELD, DESTINATION_IDENTITY_FIELD, ENTITY_ID_FIELD, LANGUAGE_FIELD,
            ORIGINATION_IDENTITY_FIELD, REFERENCE_ID_FIELD, TEMPLATE_ID_FIELD, VALIDITY_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer allowedAttempts;

    private final String brandName;

    private final String channel;

    private final Integer codeLength;

    private final String destinationIdentity;

    private final String entityId;

    private final String language;

    private final String originationIdentity;

    private final String referenceId;

    private final String templateId;

    private final Integer validityPeriod;

    private SendOTPMessageRequestParameters(BuilderImpl builder) {
        this.allowedAttempts = builder.allowedAttempts;
        this.brandName = builder.brandName;
        this.channel = builder.channel;
        this.codeLength = builder.codeLength;
        this.destinationIdentity = builder.destinationIdentity;
        this.entityId = builder.entityId;
        this.language = builder.language;
        this.originationIdentity = builder.originationIdentity;
        this.referenceId = builder.referenceId;
        this.templateId = builder.templateId;
        this.validityPeriod = builder.validityPeriod;
    }

    /**
     * <p>
     * The attempts allowed to validate an OTP.
     * </p>
     * 
     * @return The attempts allowed to validate an OTP.
     */
    public final Integer allowedAttempts() {
        return allowedAttempts;
    }

    /**
     * <p>
     * The brand name that will be substituted into the OTP message body. Should be owned by calling AWS account.
     * </p>
     * 
     * @return The brand name that will be substituted into the OTP message body. Should be owned by calling AWS
     *         account.
     */
    public final String brandName() {
        return brandName;
    }

    /**
     * <p>
     * Channel type for the OTP message. Supported values: [SMS].
     * </p>
     * 
     * @return Channel type for the OTP message. Supported values: [SMS].
     */
    public final String channel() {
        return channel;
    }

    /**
     * <p>
     * The number of characters in the generated OTP.
     * </p>
     * 
     * @return The number of characters in the generated OTP.
     */
    public final Integer codeLength() {
        return codeLength;
    }

    /**
     * <p>
     * The destination identity to send OTP to.
     * </p>
     * 
     * @return The destination identity to send OTP to.
     */
    public final String destinationIdentity() {
        return destinationIdentity;
    }

    /**
     * <p>
     * A unique Entity ID received from DLT after entity registration is approved.
     * </p>
     * 
     * @return A unique Entity ID received from DLT after entity registration is approved.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The language to be used for the outgoing message body containing the OTP.
     * </p>
     * 
     * @return The language to be used for the outgoing message body containing the OTP.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The origination identity used to send OTP from.
     * </p>
     * 
     * @return The origination identity used to send OTP from.
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * Developer-specified reference identifier. Required to match during OTP verification.
     * </p>
     * 
     * @return Developer-specified reference identifier. Required to match during OTP verification.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * A unique Template ID received from DLT after entity registration is approved.
     * </p>
     * 
     * @return A unique Template ID received from DLT after entity registration is approved.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The time in minutes before the OTP is no longer valid.
     * </p>
     * 
     * @return The time in minutes before the OTP is no longer valid.
     */
    public final Integer validityPeriod() {
        return validityPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(brandName());
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(codeLength());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(validityPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendOTPMessageRequestParameters)) {
            return false;
        }
        SendOTPMessageRequestParameters other = (SendOTPMessageRequestParameters) obj;
        return Objects.equals(allowedAttempts(), other.allowedAttempts()) && Objects.equals(brandName(), other.brandName())
                && Objects.equals(channel(), other.channel()) && Objects.equals(codeLength(), other.codeLength())
                && Objects.equals(destinationIdentity(), other.destinationIdentity())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(language(), other.language())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(referenceId(), other.referenceId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(validityPeriod(), other.validityPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendOTPMessageRequestParameters").add("AllowedAttempts", allowedAttempts())
                .add("BrandName", brandName()).add("Channel", channel()).add("CodeLength", codeLength())
                .add("DestinationIdentity", destinationIdentity()).add("EntityId", entityId()).add("Language", language())
                .add("OriginationIdentity", originationIdentity()).add("ReferenceId", referenceId())
                .add("TemplateId", templateId()).add("ValidityPeriod", validityPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedAttempts":
            return Optional.ofNullable(clazz.cast(allowedAttempts()));
        case "BrandName":
            return Optional.ofNullable(clazz.cast(brandName()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "CodeLength":
            return Optional.ofNullable(clazz.cast(codeLength()));
        case "DestinationIdentity":
            return Optional.ofNullable(clazz.cast(destinationIdentity()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "ValidityPeriod":
            return Optional.ofNullable(clazz.cast(validityPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedAttempts", ALLOWED_ATTEMPTS_FIELD);
        map.put("BrandName", BRAND_NAME_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("CodeLength", CODE_LENGTH_FIELD);
        map.put("DestinationIdentity", DESTINATION_IDENTITY_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        map.put("ValidityPeriod", VALIDITY_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendOTPMessageRequestParameters, T> g) {
        return obj -> g.apply((SendOTPMessageRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendOTPMessageRequestParameters> {
        /**
         * <p>
         * The attempts allowed to validate an OTP.
         * </p>
         * 
         * @param allowedAttempts
         *        The attempts allowed to validate an OTP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAttempts(Integer allowedAttempts);

        /**
         * <p>
         * The brand name that will be substituted into the OTP message body. Should be owned by calling AWS account.
         * </p>
         * 
         * @param brandName
         *        The brand name that will be substituted into the OTP message body. Should be owned by calling AWS
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandName(String brandName);

        /**
         * <p>
         * Channel type for the OTP message. Supported values: [SMS].
         * </p>
         * 
         * @param channel
         *        Channel type for the OTP message. Supported values: [SMS].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(String channel);

        /**
         * <p>
         * The number of characters in the generated OTP.
         * </p>
         * 
         * @param codeLength
         *        The number of characters in the generated OTP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeLength(Integer codeLength);

        /**
         * <p>
         * The destination identity to send OTP to.
         * </p>
         * 
         * @param destinationIdentity
         *        The destination identity to send OTP to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIdentity(String destinationIdentity);

        /**
         * <p>
         * A unique Entity ID received from DLT after entity registration is approved.
         * </p>
         * 
         * @param entityId
         *        A unique Entity ID received from DLT after entity registration is approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The language to be used for the outgoing message body containing the OTP.
         * </p>
         * 
         * @param language
         *        The language to be used for the outgoing message body containing the OTP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The origination identity used to send OTP from.
         * </p>
         * 
         * @param originationIdentity
         *        The origination identity used to send OTP from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * Developer-specified reference identifier. Required to match during OTP verification.
         * </p>
         * 
         * @param referenceId
         *        Developer-specified reference identifier. Required to match during OTP verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * A unique Template ID received from DLT after entity registration is approved.
         * </p>
         * 
         * @param templateId
         *        A unique Template ID received from DLT after entity registration is approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The time in minutes before the OTP is no longer valid.
         * </p>
         * 
         * @param validityPeriod
         *        The time in minutes before the OTP is no longer valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityPeriod(Integer validityPeriod);
    }

    static final class BuilderImpl implements Builder {
        private Integer allowedAttempts;

        private String brandName;

        private String channel;

        private Integer codeLength;

        private String destinationIdentity;

        private String entityId;

        private String language;

        private String originationIdentity;

        private String referenceId;

        private String templateId;

        private Integer validityPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SendOTPMessageRequestParameters model) {
            allowedAttempts(model.allowedAttempts);
            brandName(model.brandName);
            channel(model.channel);
            codeLength(model.codeLength);
            destinationIdentity(model.destinationIdentity);
            entityId(model.entityId);
            language(model.language);
            originationIdentity(model.originationIdentity);
            referenceId(model.referenceId);
            templateId(model.templateId);
            validityPeriod(model.validityPeriod);
        }

        public final Integer getAllowedAttempts() {
            return allowedAttempts;
        }

        public final void setAllowedAttempts(Integer allowedAttempts) {
            this.allowedAttempts = allowedAttempts;
        }

        @Override
        public final Builder allowedAttempts(Integer allowedAttempts) {
            this.allowedAttempts = allowedAttempts;
            return this;
        }

        public final String getBrandName() {
            return brandName;
        }

        public final void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        @Override
        public final Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final Integer getCodeLength() {
            return codeLength;
        }

        public final void setCodeLength(Integer codeLength) {
            this.codeLength = codeLength;
        }

        @Override
        public final Builder codeLength(Integer codeLength) {
            this.codeLength = codeLength;
            return this;
        }

        public final String getDestinationIdentity() {
            return destinationIdentity;
        }

        public final void setDestinationIdentity(String destinationIdentity) {
            this.destinationIdentity = destinationIdentity;
        }

        @Override
        public final Builder destinationIdentity(String destinationIdentity) {
            this.destinationIdentity = destinationIdentity;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Integer getValidityPeriod() {
            return validityPeriod;
        }

        public final void setValidityPeriod(Integer validityPeriod) {
            this.validityPeriod = validityPeriod;
        }

        @Override
        public final Builder validityPeriod(Integer validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        @Override
        public SendOTPMessageRequestParameters build() {
            return new SendOTPMessageRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
