/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEmailChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteEmailChannelResponse.Builder, DeleteEmailChannelResponse> {
    private static final SdkField<EmailChannelResponse> EMAIL_CHANNEL_RESPONSE_FIELD = SdkField
            .<EmailChannelResponse> builder(MarshallingType.SDK_POJO)
            .memberName("EmailChannelResponse")
            .getter(getter(DeleteEmailChannelResponse::emailChannelResponse))
            .setter(setter(Builder::emailChannelResponse))
            .constructor(EmailChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_CHANNEL_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EmailChannelResponse emailChannelResponse;

    private DeleteEmailChannelResponse(BuilderImpl builder) {
        super(builder);
        this.emailChannelResponse = builder.emailChannelResponse;
    }

    /**
     * Returns the value of the EmailChannelResponse property for this object.
     * 
     * @return The value of the EmailChannelResponse property for this object.
     */
    public final EmailChannelResponse emailChannelResponse() {
        return emailChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailChannelResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEmailChannelResponse)) {
            return false;
        }
        DeleteEmailChannelResponse other = (DeleteEmailChannelResponse) obj;
        return Objects.equals(emailChannelResponse(), other.emailChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEmailChannelResponse").add("EmailChannelResponse", emailChannelResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailChannelResponse":
            return Optional.ofNullable(clazz.cast(emailChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailChannelResponse", EMAIL_CHANNEL_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEmailChannelResponse, T> g) {
        return obj -> g.apply((DeleteEmailChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEmailChannelResponse> {
        /**
         * Sets the value of the EmailChannelResponse property for this object.
         *
         * @param emailChannelResponse
         *        The new value for the EmailChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailChannelResponse(EmailChannelResponse emailChannelResponse);

        /**
         * Sets the value of the EmailChannelResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EmailChannelResponse.Builder} avoiding
         * the need to create one manually via {@link EmailChannelResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailChannelResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #emailChannelResponse(EmailChannelResponse)}.
         * 
         * @param emailChannelResponse
         *        a consumer that will call methods on {@link EmailChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailChannelResponse(EmailChannelResponse)
         */
        default Builder emailChannelResponse(Consumer<EmailChannelResponse.Builder> emailChannelResponse) {
            return emailChannelResponse(EmailChannelResponse.builder().applyMutation(emailChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EmailChannelResponse emailChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEmailChannelResponse model) {
            super(model);
            emailChannelResponse(model.emailChannelResponse);
        }

        public final EmailChannelResponse.Builder getEmailChannelResponse() {
            return emailChannelResponse != null ? emailChannelResponse.toBuilder() : null;
        }

        public final void setEmailChannelResponse(EmailChannelResponse.BuilderImpl emailChannelResponse) {
            this.emailChannelResponse = emailChannelResponse != null ? emailChannelResponse.build() : null;
        }

        @Override
        public final Builder emailChannelResponse(EmailChannelResponse emailChannelResponse) {
            this.emailChannelResponse = emailChannelResponse;
            return this;
        }

        @Override
        public DeleteEmailChannelResponse build() {
            return new DeleteEmailChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
