/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInAppTemplateResponse extends PinpointResponse implements
        ToCopyableBuilder<CreateInAppTemplateResponse.Builder, CreateInAppTemplateResponse> {
    private static final SdkField<TemplateCreateMessageBody> TEMPLATE_CREATE_MESSAGE_BODY_FIELD = SdkField
            .<TemplateCreateMessageBody> builder(MarshallingType.SDK_POJO)
            .memberName("TemplateCreateMessageBody")
            .getter(getter(CreateInAppTemplateResponse::templateCreateMessageBody))
            .setter(setter(Builder::templateCreateMessageBody))
            .constructor(TemplateCreateMessageBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateCreateMessageBody").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEMPLATE_CREATE_MESSAGE_BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TemplateCreateMessageBody templateCreateMessageBody;

    private CreateInAppTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateCreateMessageBody = builder.templateCreateMessageBody;
    }

    /**
     * Returns the value of the TemplateCreateMessageBody property for this object.
     * 
     * @return The value of the TemplateCreateMessageBody property for this object.
     */
    public final TemplateCreateMessageBody templateCreateMessageBody() {
        return templateCreateMessageBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateCreateMessageBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInAppTemplateResponse)) {
            return false;
        }
        CreateInAppTemplateResponse other = (CreateInAppTemplateResponse) obj;
        return Objects.equals(templateCreateMessageBody(), other.templateCreateMessageBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInAppTemplateResponse").add("TemplateCreateMessageBody", templateCreateMessageBody())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateCreateMessageBody":
            return Optional.ofNullable(clazz.cast(templateCreateMessageBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateCreateMessageBody", TEMPLATE_CREATE_MESSAGE_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInAppTemplateResponse, T> g) {
        return obj -> g.apply((CreateInAppTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateInAppTemplateResponse> {
        /**
         * Sets the value of the TemplateCreateMessageBody property for this object.
         *
         * @param templateCreateMessageBody
         *        The new value for the TemplateCreateMessageBody property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateCreateMessageBody(TemplateCreateMessageBody templateCreateMessageBody);

        /**
         * Sets the value of the TemplateCreateMessageBody property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TemplateCreateMessageBody.Builder}
         * avoiding the need to create one manually via {@link TemplateCreateMessageBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateCreateMessageBody.Builder#build()} is called immediately
         * and its result is passed to {@link #templateCreateMessageBody(TemplateCreateMessageBody)}.
         * 
         * @param templateCreateMessageBody
         *        a consumer that will call methods on {@link TemplateCreateMessageBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateCreateMessageBody(TemplateCreateMessageBody)
         */
        default Builder templateCreateMessageBody(Consumer<TemplateCreateMessageBody.Builder> templateCreateMessageBody) {
            return templateCreateMessageBody(TemplateCreateMessageBody.builder().applyMutation(templateCreateMessageBody).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private TemplateCreateMessageBody templateCreateMessageBody;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInAppTemplateResponse model) {
            super(model);
            templateCreateMessageBody(model.templateCreateMessageBody);
        }

        public final TemplateCreateMessageBody.Builder getTemplateCreateMessageBody() {
            return templateCreateMessageBody != null ? templateCreateMessageBody.toBuilder() : null;
        }

        public final void setTemplateCreateMessageBody(TemplateCreateMessageBody.BuilderImpl templateCreateMessageBody) {
            this.templateCreateMessageBody = templateCreateMessageBody != null ? templateCreateMessageBody.build() : null;
        }

        @Override
        public final Builder templateCreateMessageBody(TemplateCreateMessageBody templateCreateMessageBody) {
            this.templateCreateMessageBody = templateCreateMessageBody;
            return this;
        }

        @Override
        public CreateInAppTemplateResponse build() {
            return new CreateInAppTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
