/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies address-based configuration settings for a message that's sent directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressConfiguration.Builder, AddressConfiguration> {
    private static final SdkField<String> BODY_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BodyOverride").getter(getter(AddressConfiguration::bodyOverride)).setter(setter(Builder::bodyOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyOverride").build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelType").getter(getter(AddressConfiguration::channelTypeAsString))
            .setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(AddressConfiguration::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RawContent").getter(getter(AddressConfiguration::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Substitutions")
            .getter(getter(AddressConfiguration::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TITLE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TitleOverride").getter(getter(AddressConfiguration::titleOverride))
            .setter(setter(Builder::titleOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_OVERRIDE_FIELD,
            CHANNEL_TYPE_FIELD, CONTEXT_FIELD, RAW_CONTENT_FIELD, SUBSTITUTIONS_FIELD, TITLE_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bodyOverride;

    private final String channelType;

    private final Map<String, String> context;

    private final String rawContent;

    private final Map<String, List<String>> substitutions;

    private final String titleOverride;

    private AddressConfiguration(BuilderImpl builder) {
        this.bodyOverride = builder.bodyOverride;
        this.channelType = builder.channelType;
        this.context = builder.context;
        this.rawContent = builder.rawContent;
        this.substitutions = builder.substitutions;
        this.titleOverride = builder.titleOverride;
    }

    /**
     * <p>
     * The message body to use instead of the default message body. This value overrides the default message body.
     * </p>
     * 
     * @return The message body to use instead of the default message body. This value overrides the default message
     *         body.
     */
    public final String bodyOverride() {
        return bodyOverride;
    }

    /**
     * <p>
     * The channel to use when sending the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel to use when sending the message.
     * @see ChannelType
     */
    public final ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * The channel to use when sending the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel to use when sending the message.
     * @see ChannelType
     */
    public final String channelTypeAsString() {
        return channelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps custom attributes to attributes for the address and is attached to the message. Attribute
     * names are case sensitive.
     * </p>
     * <p>
     * For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this
     * payload is added to email/SMS delivery receipt event attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return An object that maps custom attributes to attributes for the address and is attached to the message.
     *         Attribute names are case sensitive.</p>
     *         <p>
     *         For a push notification, this payload is added to the data.pinpoint object. For an email or text message,
     *         this payload is added to email/SMS delivery receipt event attributes.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all
     * other values for the message.
     * </p>
     * 
     * @return The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides
     *         all other values for the message.
     */
    public final String rawContent() {
        return rawContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Substitutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubstitutions() {
        return substitutions != null && !(substitutions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the message variables to merge with the variables specified by properties of the DefaultMessage object.
     * The variables specified in this map take precedence over all other variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubstitutions} method.
     * </p>
     * 
     * @return A map of the message variables to merge with the variables specified by properties of the DefaultMessage
     *         object. The variables specified in this map take precedence over all other variables.
     */
    public final Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * <p>
     * The message title to use instead of the default message title. This value overrides the default message title.
     * </p>
     * 
     * @return The message title to use instead of the default message title. This value overrides the default message
     *         title.
     */
    public final String titleOverride() {
        return titleOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bodyOverride());
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubstitutions() ? substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(titleOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressConfiguration)) {
            return false;
        }
        AddressConfiguration other = (AddressConfiguration) obj;
        return Objects.equals(bodyOverride(), other.bodyOverride())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString()) && hasContext() == other.hasContext()
                && Objects.equals(context(), other.context()) && Objects.equals(rawContent(), other.rawContent())
                && hasSubstitutions() == other.hasSubstitutions() && Objects.equals(substitutions(), other.substitutions())
                && Objects.equals(titleOverride(), other.titleOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressConfiguration").add("BodyOverride", bodyOverride())
                .add("ChannelType", channelTypeAsString()).add("Context", hasContext() ? context() : null)
                .add("RawContent", rawContent()).add("Substitutions", hasSubstitutions() ? substitutions() : null)
                .add("TitleOverride", titleOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BodyOverride":
            return Optional.ofNullable(clazz.cast(bodyOverride()));
        case "ChannelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "TitleOverride":
            return Optional.ofNullable(clazz.cast(titleOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BodyOverride", BODY_OVERRIDE_FIELD);
        map.put("ChannelType", CHANNEL_TYPE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("RawContent", RAW_CONTENT_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        map.put("TitleOverride", TITLE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressConfiguration, T> g) {
        return obj -> g.apply((AddressConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressConfiguration> {
        /**
         * <p>
         * The message body to use instead of the default message body. This value overrides the default message body.
         * </p>
         * 
         * @param bodyOverride
         *        The message body to use instead of the default message body. This value overrides the default message
         *        body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyOverride(String bodyOverride);

        /**
         * <p>
         * The channel to use when sending the message.
         * </p>
         * 
         * @param channelType
         *        The channel to use when sending the message.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * The channel to use when sending the message.
         * </p>
         * 
         * @param channelType
         *        The channel to use when sending the message.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * An object that maps custom attributes to attributes for the address and is attached to the message. Attribute
         * names are case sensitive.
         * </p>
         * <p>
         * For a push notification, this payload is added to the data.pinpoint object. For an email or text message,
         * this payload is added to email/SMS delivery receipt event attributes.
         * </p>
         * 
         * @param context
         *        An object that maps custom attributes to attributes for the address and is attached to the message.
         *        Attribute names are case sensitive.</p>
         *        <p>
         *        For a push notification, this payload is added to the data.pinpoint object. For an email or text
         *        message, this payload is added to email/SMS delivery receipt event attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all
         * other values for the message.
         * </p>
         * 
         * @param rawContent
         *        The raw, JSON-formatted string to use as the payload for the message. If specified, this value
         *        overrides all other values for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * <p>
         * A map of the message variables to merge with the variables specified by properties of the DefaultMessage
         * object. The variables specified in this map take precedence over all other variables.
         * </p>
         * 
         * @param substitutions
         *        A map of the message variables to merge with the variables specified by properties of the
         *        DefaultMessage object. The variables specified in this map take precedence over all other variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * <p>
         * The message title to use instead of the default message title. This value overrides the default message
         * title.
         * </p>
         * 
         * @param titleOverride
         *        The message title to use instead of the default message title. This value overrides the default
         *        message title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOverride(String titleOverride);
    }

    static final class BuilderImpl implements Builder {
        private String bodyOverride;

        private String channelType;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private String rawContent;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String titleOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressConfiguration model) {
            bodyOverride(model.bodyOverride);
            channelType(model.channelType);
            context(model.context);
            rawContent(model.rawContent);
            substitutions(model.substitutions);
            titleOverride(model.titleOverride);
        }

        public final String getBodyOverride() {
            return bodyOverride;
        }

        public final void setBodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
        }

        @Override
        public final Builder bodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
            return this;
        }

        public final String getChannelType() {
            return channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final String getRawContent() {
            return rawContent;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final String getTitleOverride() {
            return titleOverride;
        }

        public final void setTitleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
        }

        @Override
        public final Builder titleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
            return this;
        }

        @Override
        public AddressConfiguration build() {
            return new AddressConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
